<?php

/**
 * This is the model class for table "section_limits".
 *
 * The followings are the available columns in table 'section_limits':
 * @property string $id
 * @property string $section
 * @property string $class
 * @property double $road_speed_limit
 * @property double $road_speed_threshold
 * @property string $epoch
 * @property double Tolerance
 */
class SectionLimits extends ActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return SectionLimits the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'section_limits';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('section, class, road_speed_limit, road_speed_threshold, epoch', 'required'),
			array('road_speed_limit, road_speed_threshold', 'numerical'),
			array('section', 'length', 'max'=>10),
			array('class', 'length', 'max'=>256),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, section, class, road_speed_limit, road_speed_threshold, epoch', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'section' => 'Section',
			'class' => 'Class',
			'road_speed_limit' => 'Road Speed Limit',
			'road_speed_threshold' => 'Road Speed Threshold',
			'epoch' => 'Epoch',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id,true);
		$criteria->compare('section',$this->section,true);
		$criteria->compare('class',$this->class,true);
		$criteria->compare('road_speed_limit',$this->road_speed_limit);
		$criteria->compare('road_speed_threshold',$this->road_speed_threshold);
		$criteria->compare('epoch',$this->epoch,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
	
	public function getTolerance()
	{
	  $tol = $this->road_speed_limit/$this->road_speed_threshold;
	  $tol = $tol * 100.0;
	  $tol = 100.0 - $tol;
	  return round($tol,2);
	}
}