<?php

/**
 * This is the model class for table "user_settings".
 *
 * The followings are the available columns in table 'user_settings':
 * @property integer $id
 * @property integer $id_user
 * @property string $key
 * @property string $value
 * @property string $epoch
 */
class UserSettings extends ActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return UserSettings the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'user_settings';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('key', 'required'),
			array('id_user', 'numerical', 'integerOnly'=>true),
			array('key, value', 'length', 'max'=>255),
			array('epoch', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, id_user, key, value, epoch', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function myAttributeLabels()
	{
		return array(
			'id' => 'ID',
			'id_user' => 'Id User',
			'key' => 'Key',
			'value' => 'Value',
			'epoch' => 'Epoch',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('id_user',$this->id_user);
		$criteria->compare('key',$this->key,true);
		$criteria->compare('value',$this->value,true);
		$criteria->compare('epoch',$this->epoch,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
	
	/**
	 * 
	 * @param integer $user
	 * @return UserSettings[]
	 */
	public static function getValues($user)
	{
	  return UserSettings::model()->findAll('t.id_user=:idusr',array(':idusr'=>$user));
	}
	
	/**
	 * 
	 * @param integer $user
	 * @param string $key
	 * @return UserSettings
	 */
	public static function getValueForUser($user, $key)
	{
	  return UserSettings::model()->find('t.id_user=:idusr AND t.key=:ky',array(':idusr'=>$user, ':ky'=>$key));
	}
	
	/**
	 * @param integer $user
	 * @param string $key
	 * @param string $value
	 * @return boolean
	 */
	public static function setValueForUser($user, $key, $value)
	{
	  $now = new DateTimeEx();
	  $stng = UserSettings::getValueForUser($user, $key);
	  if($stng == null)
	  {
	    if($value === null)
	      return true;
	    else
	    {
  	    $stng = new UserSettings();
  	    $stng->id_user = $user;
  	    $stng->key = $key;
  	    $stng->value = $value;
  	    $stng->epoch = $now->toDateTimeString();
  	    return $stng->insert();
	    } 
	  }
	  else
	  {
	    if($value === null)
	      return $stng->delete();
	    else
	    {
	      $stng->value = $value;
  	    $stng->epoch = $now->toDateTimeString();
	      return $stng->save(); 
	    }
	  }
	}
}