<?php

/**
 * This is the model class for table "statsvaluestable".
 *
 * The followings are the available columns in table 'gatetable':
 * @property integer $id                Chiave primaria record
 * @property integer $StatID            id statistica di riferimento
 * @property string  $ValueID           numerale indice dell intervallo
 * @property integer $Counter           numero di veicoli
 * @property double  $StartValue        Valore iniziale di velocità dell'intervallo
 * @property double  $EndValue        Valore finale di velocità dell'intervallo
 * @property integer $Descritpion       descrizione intervallo
  */

class VehiclesFrequencyBySpeed extends ActiveRecord
{
  public static function model($className=__CLASS__)
  {
    return parent::model($className);
  }

  public function tableName()
  {
    return 'statsvaluestable';
  }

  public function relations()
  {
    return array(
      'vehicleType' => array(self::BELONGS_TO, 'VehiclesFrequencyByType', 'StatID'),
    );
  }


  public function speedFrom($minSpeed)
  {
    $this->getDbCriteria()->mergeWith(
        array(
            'condition' => 'StartValue >= :startVal',
            'params' => array(
                ':startVal' => $minSpeed,
            ),
        )
    );

    return $this;
  }

  public function speedTo($maxSpeed)
  {
    $this->getDbCriteria()->mergeWith(
        array(
            'condition' => 'EndValue <= :endVal',
            'params' => array(
                ':endVal' => $maxSpeed,
            ),
        )
    );

    return $this;
  }

}
