<?php

class ZtlValidityResult implements ISortable
{

  /**
   *
   * @var DateTime
   */
  public $timestamp = null;

  /**
   *
   * @var bool
   */
  public $isValid = false;

  /**
   *
   * @var Ztl
   */
  public $ztl = null;

  /**
   *
   * @var TimeSchedule
   */
  public $timeSchedule = null;

  /**
   *
   * @var TimeSlot[]
   */
  public $validTimeSlots = array ();

  /**
   *
   * @var int
   */
  public $priorityForSchedule = - 1;

  /**
   *
   * @var int
   */
  public $priorityForSlot = - 1;

  /**
   * (non-PHPdoc)
   *
   * @see ISortable::compare()
   * @param ZtlValidityResult $other          
   */
  public function compare($other)
  {
    $result = 0;
    
    if ($this->priorityForSchedule == $other->priorityForSchedule)
    {
      if ($this->priorityForSlot == $other->priorityForSlot)
      {
        $result = 0;
      }
      else
        $result = $this->priorityForSlot < $other->priorityForSlot ? - 1 : 1;
    }
    else
      $result = $this->priorityForSchedule < $other->priorityForSchedule ? - 1 : 1;
    return $result;
  }
}
