<?php
/**
 * AssignmentController class file.
 * @author Christoffer Niska <ChristofferNiska@gmail.com>
 * @copyright Copyright &copy; Christoffer Niska 2012-
 * @license http://www.opensource.org/licenses/bsd-license.php New BSD License
 * @package auth.controllers
 */

/**
 * Controller for assignment related actions.
 */
class FastAssignController extends AuthController
{
  /**
   * Displays the a list of all the assignments.
   */
  public function actionIndex($user=null)
  {
    $this->render("index");
  }

  public function actionUser($user)
  {
    $u = User::model()->findByPk($user);
    if($u == null)
      throw new CHttpException(404,'Username not found');
  
    $actions = array();
  
    $assign = $_REQUEST["assign"];
    if($assign === null || count($assign) <= 0)
      $assign = array();
  
    foreach($assign as $k => $v)
    if($v != $original[$k])
      $actions[$k] = $v == "1";
  
    $original = $_REQUEST["original"];
    if($original === null || count($original) <= 0)
      $original = array();
  
    foreach ($original as $k => $v)
    if(!array_key_exists($k, $assign) && $v == "1")
      $actions[$k] = false;
  
    foreach($actions as $k => $v)
    {
      $ass = AuthAssignment::model()->find('itemname=:i AND userid=:u',array(':i'=>$k,':u'=>$u->id));
      if($v)
      {
        if($ass == null)
        {
          $ass = new AuthAssignment();
          $ass->itemname = $k;
          $ass->userid = $u->id;
          $ass->insert();
        }
      }
      else
      {
        if($ass != null)
          $ass->delete();
      }
    }
  
    $assigns = AuthAssignment::getAllAssignments($u->id);
  
    $items = array();
    foreach (AuthItem::getAll('name') as $item)
    {
      $row = array();
      $row["name"] = $item->name;
      $row["description"] = $item->description;
      $row["type"] = $item->getTypeName();
      $row["found"] = false;
      foreach($assigns as $a)
      {
        if($a->name == $item->name)
        {
          $row["found"] = true;
          break;
        }
      }
      $items[] = $row;
    }
    $this->render("assign_user", array(
        'items'=>$items,
        'user'=>$u,
    ));
  }

  public function actionRole($role)
  {
    $u = AuthItem::model()->find('type=2 AND name=:r', array(':r'=>$role));
    if($u == null)
      throw new CHttpException(404,'Username not found');
  
    $actions = array();
  
    $assign = $_REQUEST["assign"];
    if($assign === null || count($assign) <= 0)
      $assign = array();
  
    foreach($assign as $k => $v)
    if($v != $original[$k])
      $actions[$k] = $v == "1";
  
    $original = $_REQUEST["original"];
    if($original === null || count($original) <= 0)
      $original = array();
  
    foreach ($original as $k => $v)
    if(!array_key_exists($k, $assign) && $v == "1")
      $actions[$k] = false;
  
    foreach($actions as $k => $v)
    {
      $ass = AuthItemChild::model()->find('child=:i AND parent=:u',array(':i'=>$k,':u'=>$u->name));
      if($v)
      {
        if($ass == null)
        {
          $ass = new AuthItemChild();
          $ass->child = $k;
          $ass->parent= $u->name;
          $ass->insert();
        }
      }
      else
      {
        if($ass != null)
          $ass->delete();
      }
    }
  
    $assigns = AuthItem::getAllTree($u->name);
  
    $items = array();
    foreach (AuthItem::getAll('name', array(1,0)) as $item)
    {
      if($item->name == $role)
        continue;
      $row = array();
      $row["name"] = $item->name;
      $row["description"] = $item->description;
      $row["type"] = $item->getTypeName();
      $row["found"] = false;
      foreach($assigns as $a)
      {
        if($a->name == $item->name)
        {
          $row["found"] = true;
          break;
        }
      }
      $items[] = $row;
    }
    $this->render("assign_role", array(
        'items'=>$items,
        'role'=>$u,
    ));
  }
  

  public function actionTask($task)
  {
    $u = AuthItem::model()->find('type=1 AND name=:r', array(':r'=>$task));
    if($u == null)
      throw new CHttpException(404,'Username not found');
  
    $actions = array();
  
    $assign = $_REQUEST["assign"];
    if($assign === null || count($assign) <= 0)
      $assign = array();
  
    foreach($assign as $k => $v)
    if($v != $original[$k])
      $actions[$k] = $v == "1";
  
    $original = $_REQUEST["original"];
    if($original === null || count($original) <= 0)
      $original = array();
  
    foreach ($original as $k => $v)
    if(!array_key_exists($k, $assign) && $v == "1")
      $actions[$k] = false;
  
    foreach($actions as $k => $v)
    {
      $ass = AuthItemChild::model()->find('child=:i AND parent=:u',array(':i'=>$k,':u'=>$u->name));
      if($v)
      {
        if($ass == null)
        {
          $ass = new AuthItemChild();
          $ass->child = $k;
          $ass->parent= $u->name;
          $ass->insert();
        }
      }
      else
      {
        if($ass != null)
          $ass->delete();
      }
    }
  
    $assigns = AuthItem::getAllTree($u->name);
  
    $items = array();
    foreach (AuthItem::getAll('name', 0) as $item)
    {
      if($item->name == $task)
        continue;
      $row = array();
      $row["name"] = $item->name;
      $row["description"] = $item->description;
      $row["type"] = $item->getTypeName();
      $row["found"] = false;
      foreach($assigns as $a)
      {
        if($a->name == $item->name)
        {
          $row["found"] = true;
          break;
        }
      }
      $items[] = $row;
    }
    $this->render("assign_task", array(
        'items'=>$items,
        'task'=>$u,
    ));
  }
}