<?php

class EventPresenter extends SimpleDelegator
{

  public function getVelocita()
  {
    $speed = $this->vehicleSpeed;
    if ($speed < 0)
      return "-";
    else
      return sprintf("%.2f", $speed);
  }
  
  public function getVehicleKemler()
  {
    return $this->Kemler;
  }

  public function getVehicleKemlerDescription()
  {
      $kemlerCode = $this->Kemler;
      $adrDescription = $this->getAdrDescription($kemlerCode);
      $onuDescription = $this->getOnuDescription($kemlerCode);
      if (isset($adrDescription) && isset($onuDescription))
        return "{$adrDescription} - {$onuDescription}";    
  }
  
  public function getVehicleClassIcon()
  {
    $vehicle_class = $this->vehicleClass;
    if($vehicle_class == null)
      return null;
  
    return strtolower($vehicle_class.".png");
  }
  
  public function getAlertDateTime()
  {
     return $this->eventDateTime;
  }
  
  private function getAdrDescription($kemlerCode)
  {
    $kemler = new Kemler($kemlerCode);
    $adr = $kemler->adr;
    if (isset($adr))
      return $adr->description;
  }
  
  private function getOnuDescription($kemlerCode)
  {
    $kemler = new Kemler($kemlerCode);
    $onu = $kemler->onu;
    if (isset($onu))
      return $onu->description;
  }







}
