<div id="gate-group-index-page">
  <div class="page-header">
    <h2>
      <li class="icon-cog"></li>
      <?php echo htmlspecialchars(Yii::t("app", "Gates"),ENT_QUOTES,'UTF-8'); ?>
    </h2>
  </div>
  <div class="row">
    <?php $gates = Gate::getAllGates(); ?>
    <div class="tableContainer pagination-data-container">
      <table class="table table-condensed span12">
        <thead>
          <tr></tr>
          <tr>
            <?php if(user()->checkAccess('view_live')) { ?>
              <th></th>
            <?php } ?>
            <th></th>
            <th></th>
            <th><?php echo htmlspecialchars(t('ID'),ENT_QUOTES,'UTF-8'); ?></th>
            <th><?php echo htmlspecialchars(t('Description'),ENT_QUOTES,'UTF-8'); ?></th>
            <th><?php echo htmlspecialchars(t('S/N'),ENT_QUOTES,'UTF-8'); ?></th>
            <th><?php echo htmlspecialchars(t('IP'),ENT_QUOTES,'UTF-8'); ?></th>
            <th><?php echo htmlspecialchars(t('Device'),ENT_QUOTES,'UTF-8'); ?></th>
            <th><?php echo htmlspecialchars(t('Group'),ENT_QUOTES,'UTF-8'); ?></th>
            <th><?php echo htmlspecialchars(t('Short name'),ENT_QUOTES,'UTF-8'); ?></th>
            <th><?php echo htmlspecialchars(t('Code'),ENT_QUOTES,'UTF-8'); ?></th>
            <th>
              <a <?php echo MtHaml\Runtime::renderAttributes(array(array('class', ('btn' . ' ' . 'btn-mini')), array('href', (Yii::app()->createAbsoluteUrl('gate/create')))), 'html5', 'UTF-8'); ?>>
                <?php echo htmlspecialchars(Yii::t('app', 'New gate')   ,ENT_QUOTES,'UTF-8'); ?>
              </a>
            </th>
          </tr>
        </thead>
        <tbody>
          <?php foreach($gates as $gate) { ?>
            <?php $gate = new GatePresenter($gate); ?>
            <tr>
              <?php if(user()->checkAccess('view_live')) { ?>
                <td>
                  <?php if($gate->hasLive()) { ?>
                    <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', ($gate->LivePageUrl)), array('target', '_blank'), array('title', (t('Live')))), 'html5', 'UTF-8'); ?>>
                      <div class="icon-facetime-video"></div>
                    </a>
                  <?php } ?>
                </td>
              <?php } ?>
              <td>
                <?php if($gate->hasCoordinates()) { ?>
                  <a <?php echo MtHaml\Runtime::renderAttributes(array(array('title', (($gate->latitude) . ' , ' . ($gate->longitude))), array('href', ($gate->getGoogleMapsLink())), array('target', '_blank')), 'html5', 'UTF-8'); ?>>
                    <div class="icon-map-marker"></div>
                  </a>
                <?php } ?>
              </td>
              <td>
                <?php $lastLifeSignal = $gate->LastLifeSignal == null ? t("Never") : "".new DateTimeEx($gate->LastLifeSignal); ?>
                <span <?php echo MtHaml\Runtime::renderAttributes(array(array('class', ('status-icon' . ' ' . 'icon-circle')), array('class', ($gate->statusClass)), array('title', $lastLifeSignal)), 'html5', 'UTF-8'); ?>></span>
              </td>
              <td>
                <?php echo htmlspecialchars($gate->ID,ENT_QUOTES,'UTF-8'); ?>
              </td>
              <td>
                <?php echo htmlspecialchars($gate->Descrizione,ENT_QUOTES,'UTF-8'); ?>
              </td>
              <td>
                <?php echo htmlspecialchars($gate->Gate,ENT_QUOTES,'UTF-8'); ?>
              </td>
              <td>
                <?php echo htmlspecialchars($gate->IP,ENT_QUOTES,'UTF-8'); ?>
              </td>
              <td>
                <?php echo htmlspecialchars(t($gate->GateType),ENT_QUOTES,'UTF-8'); ?>
              </td>
              <td>
                <?php echo SystemInfoHelper::getGateGroupCoolName($gate->id_group); ?>
              </td>
              <td>
                <?php echo htmlspecialchars($gate->short_name,ENT_QUOTES,'UTF-8'); ?>
              </td>
              <td>
                <?php echo htmlspecialchars($gate->Code,ENT_QUOTES,'UTF-8'); ?>
              </td>
              <td>
                <div class="btn-group">
                  <a class="btn btn-small dropdown-toggle" data-toggle="dropdown" href="#">
                    <?php echo htmlspecialchars(Yii::t("app", "Actions"),ENT_QUOTES,'UTF-8'); ?>
                    <span class="caret"></span>
                  </a>
                  <ul class="dropdown-menu pull-right">
                    <li>
                      <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (Yii::app()->createUrl('gate/view', array('id' => $gate->ID))))), 'html5', 'UTF-8'); ?>>
                        <?php echo htmlspecialchars(Yii::t("app", ("View")),ENT_QUOTES,'UTF-8'); ?>
                      </a>
                    </li>
                    <li>
                      <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (Yii::app()->createUrl('gate/update', array('id' => $gate->ID))))), 'html5', 'UTF-8'); ?>>
                        <?php echo htmlspecialchars(Yii::t("app", ("Modify")),ENT_QUOTES,'UTF-8'); ?>
                      </a>
                    </li>
                    <li>
                      <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (Yii::app()->createUrl('gate/delete', array('id' => $gate->ID))))), 'html5', 'UTF-8'); ?>>
                        <?php echo htmlspecialchars(Yii::t("app", ("Delete")) ,ENT_QUOTES,'UTF-8'); ?>
                      </a>
                    </li>
                  </ul>
                </div>
              </td>
            </tr>
          <?php } ?>
        </tbody>
      </table>
    </div>
  </div>
</div>
