<tr>
  <td class="license-plate">
    <div class="licence-plate-box">
      <?php if($event->nationalityCode != '') { ?>
        <?php $this->renderPartial('/shared/_countryFlag', array('isoCode' => $event->nationalityCode)); ?>
      <?php } else { ?>
        <img width="16px" />
      <?php } ?>
      <?php echo htmlspecialchars($event->Plate,ENT_QUOTES,'UTF-8'); ?>
    </div>
  </td>
  <td class="license-plate">
    <div class="licence-plate-box">
      <?php echo htmlspecialchars($event->ExtPlate,ENT_QUOTES,'UTF-8'); ?>
    </div>
  </td>
  <td class="plate-layout">
    <?php echo htmlspecialchars($event->Nationality,ENT_QUOTES,'UTF-8'); ?>
  </td>
  <td <?php echo MtHaml\Runtime::renderAttributes(array(array('title', ($event->Gate))), 'html5', 'UTF-8'); ?>>
    <?php $gt = $event->gate; ?>
    <?php if($gt != null) { ?>
      <?php if(empty($gt->short_name)) { ?>
        <?php echo htmlspecialchars($gt->Descrizione,ENT_QUOTES,'UTF-8'); ?>
      <?php } else { ?>
        <?php echo htmlspecialchars($gt->short_name,ENT_QUOTES,'UTF-8'); ?>
      <?php } ?>
    <?php } else { ?>
      <?php echo htmlspecialchars($event->GateDescription,ENT_QUOTES,'UTF-8'); ?>
    <?php } ?>
  </td>
  <td>
    <?php echo htmlspecialchars(DateHelper::ensureObjectEx($event->StartTime),ENT_QUOTES,'UTF-8'); ?>
  </td>
  <td>
    <?php echo htmlspecialchars($event->Velocita,ENT_QUOTES,'UTF-8'); ?>
  </td>
  <td>
    <img <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'vehicle-class-icon-small'), array('src', ((Yii::app()->baseUrl) . '/images/vehicle-classes/' . ($event->VehicleClassIcon)))), 'html5', 'UTF-8'); ?> />
  </td>
  <td>
    <?php if(user()->checkAccess('media_view_photo')) { ?>
      <?php $photoBN = $event->previewPhotoUrl; ?>
      <?php if(!empty($photoBN)) { ?>
        <a <?php echo MtHaml\Runtime::renderAttributes(array(array('title', (t('Black/White photo'))), array('href', $photoBN), array('data-lightbox', ('violation-preview-' . ($event->ID)))), 'html5', 'UTF-8'); ?>>
          <i class="icon-zoom-in"></i>
        </a>
      <?php } ?>
      <?php $photoCOL = $event->previewColorPhotoUrl; ?>
      <?php if(!empty($photoCOL)) { ?>
        <a <?php echo MtHaml\Runtime::renderAttributes(array(array('title', (t('Color photo'))), array('href', $photoCOL), array('data-lightbox', ('violation-preview-' . ($event->ID)))), 'html5', 'UTF-8'); ?>>
          <i class="icon-zoom-in"></i>
        </a>
      <?php } ?>
    <?php } ?>
  </td>
  <td>
    <button <?php echo MtHaml\Runtime::renderAttributes(array(array('class', ('export-images' . ' ' . 'btn' . ' ' . 'btn-mini')), array('type', 'button'), array('data-event-id', ($event->ID)), array('data-event-export-time', $exportTime), array('data-confirm-text', (t('Confirm?')))), 'html5', 'UTF-8'); ?>>
      <?php echo htmlspecialchars(t('Export'),ENT_QUOTES,'UTF-8'); ?>
    </button>
  </td>
</tr>
