<h2>
  <div class="icon-road"></div>
  <?php echo htmlspecialchars(t(paramdeep('ztl','name')),ENT_QUOTES,'UTF-8'); ?>
</h2>
<?php if(user()->checkAccess('ztl_edit')) { ?>
  <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (url('ztlEditor/admin')))), 'html5', 'UTF-8'); ?>>
    <h5>
      <?php echo htmlspecialchars(t('Edit'),ENT_QUOTES,'UTF-8'); ?>
    </h5>
  </a>
<?php } ?>
<h4>
  <?php echo htmlspecialchars(t('Gates').':',ENT_QUOTES,'UTF-8'); ?>
</h4>
<table class="table table-condensed">
  <thead>
    <tr>
      <th><?php echo htmlspecialchars(t('Current status'),ENT_QUOTES,'UTF-8'); ?></th>
      <th><?php echo htmlspecialchars(t('Description'),ENT_QUOTES,'UTF-8'); ?></th>
      <th><?php echo htmlspecialchars(t('Time Schedules'),ENT_QUOTES,'UTF-8'); ?></th>
      <th><?php echo htmlspecialchars(t('Code'),ENT_QUOTES,'UTF-8'); ?></th>
      <th><?php echo htmlspecialchars(t('Actions'),ENT_QUOTES,'UTF-8'); ?></th>
    </tr>
  </thead>
  <tbody></tbody>
  <?php foreach(Gate::getAllGates() as $gate) { ?>
    <tr>
      <td>
        <?php if(!$gate->isZtlLimited()) { ?>
          <font color="green">
            <?php echo htmlspecialchars(t('Free access'),ENT_QUOTES,'UTF-8'); ?>
          </font>
        <?php } else { ?>
          <font color="red">
            <?php echo htmlspecialchars(t('Limited access'),ENT_QUOTES,'UTF-8'); ?>
          </font>
        <?php } ?>
      </td>
      <td>
        <?php echo SystemInfoHelper::getGateCoolName($gate->ID); ?>
      </td>
      <td>
        <?php echo $gate->getZtlIconTags(); ?>
      </td>
      <td>
        <?php echo htmlspecialchars($gate->Gate,ENT_QUOTES,'UTF-8'); ?>
      </td>
      <td>
        <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', ('gateSchedule?gate=' . ($gate->Gate)))), 'html5', 'UTF-8'); ?>>
          <div <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'icon-eye-open'), array('title', (t('View scheduling')))), 'html5', 'UTF-8'); ?>></div>
        </a>
        <?php if(user()->checkAccess('ztl_edit')) { ?>
          <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (url('ztleditor/admin?Ztl[GateID]='.$gate->Descrizione)))), 'html5', 'UTF-8'); ?>>
            <div <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'icon-pencil'), array('title', (t('Update')))), 'html5', 'UTF-8'); ?>></div>
          </a>
        <?php } ?>
      </td>
    </tr>
  <?php } ?>
</table>
