<div id="live-page">
  <h3>
    <?php echo htmlspecialchars(t("Live"),ENT_QUOTES,'UTF-8'); ?>
  </h3>
  <span8>
    <table>
      <tr>
        <td>
          <div class="span4">
            <div class="live-list-container span3">
              <div class="live-title">
                <?php echo htmlspecialchars(t("Live"),ENT_QUOTES,'UTF-8'); ?>
              </div>
              <?php foreach($gates as $gate) { ?>
                <?php if($gate->hasLive()) { ?>
                  <?php $liveUrl = $gate->LivePageUrl; ?>
                  <section>
                    <span class="title">
                      <a <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'icon-facetime-video'), array('href', $liveUrl)), 'html5', 'UTF-8'); ?>>
                        <?php echo htmlspecialchars($gate->Descrizione,ENT_QUOTES,'UTF-8'); ?>
                      </a>
                    </span>
                  </section>
                <?php } ?>
              <?php } ?>
              <section>
                <span class="title">
                  <a <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'icon-th-large'), array('href', (Yii::app()->createUrl('live/wall')))), 'html5', 'UTF-8'); ?>>
                    <?php echo htmlspecialchars(t('View Wall'),ENT_QUOTES,'UTF-8'); ?>
                  </a>
                </span>
              </section>
            </div>
          </div>
        </td>
        <td>
          <?php if($selectedGate != null) { ?>
            <?php echo htmlspecialchars(t('Current gate: '),ENT_QUOTES,'UTF-8'); ?>
            <b>
              <?php echo htmlspecialchars($selectedGate->Descrizione,ENT_QUOTES,'UTF-8'); ?>
            </b>
            <?php $this->widget('ext.jwplayer.JwPlayer',array(  'rtmpPath'=>$selectedGate->live_url,'flvName'=>$selectedGate->live_url,'width'=>1360/2,'height'=>1024/2,'autoStart'=>true));; ?>
          <?php } ?>
        </td>
      </tr>
    </table>
  </span8>
</div>
