<div id="dashboard-page">
  <?php $user = Yii::app()->user; ?>
  <?php $emptyDashboard = true; ?>
  <div class="page-header">
    <h2>
      <li class="icon-th"></li>
      <?php echo htmlspecialchars(Yii::t("app", "Dashboard"),ENT_QUOTES,'UTF-8'); ?>
    </h2>
  </div>
  <div class="row">
    <?php if($user->checkAccess('start_stop_service') || $user->checkAccess('view_services_status')) { ?>
      <?php $emptyDashboard = false; ?>
      <div class="span4">
        <h3><?php echo htmlspecialchars(Yii::t("app", "Tasks"),ENT_QUOTES,'UTF-8'); ?></h3>
        <div id="services-table">
        </div>
        <div id="service-manual-start-modal" class="modal hide fade"></div>
      </div>
    <?php } ?>
    <?php if (Yii::app()->user->checkAccess('create_events_report') || Yii::app()->user->checkAccess('show_sessions_details')) { ?>
      <?php $emptyDashboard = false; ?>
      <div class="span8">
        <h3>
          <?php echo htmlspecialchars(Yii::t("app", "Activity Report"),ENT_QUOTES,'UTF-8'); ?>
        </h3>
        <div class="box session alert alert-normal">
          <?php $this->renderPartial('workPeriod/_eventsReport', array('workPeriods' => $workPeriods, 'pagination'=> false)); ?>
        </div>
      </div>
    <?php } ?>
    <?php if ( count( $plateLists ) > 0 ) { ?>
      <?php $emptyDashboard = false; ?>
      <div class="span8">
        <h3>
          <?php echo htmlspecialchars(Yii::t("app", "Plate authorizations"),ENT_QUOTES,'UTF-8'); ?>
        </h3>
        <div class="box session alert alert-normal">
          <?php $this->renderPartial('plateAuths/_plateAuthSummary', array('plateLists'=>$plateLists)); ?>
        </div>
      </div>
    <?php } ?>
  </div>
  <?php if($emptyDashboard)               { ?>
    <div class="row">
      <div id="menu-cloud" class="span12"></div>
      <?php $this->renderPartial('_tagcanvasCloud'); ?>
    </div>
  <?php } ?>
</div>
