<h2><?php echo htmlspecialchars(t('Violation Document List Details'),ENT_QUOTES,'UTF-8'); ?></h2>
<table class="reporttable table table-striped">
  <thead>
    <tr>
      <th><?php echo htmlspecialchars(t('Verbale'),ENT_QUOTES,'UTF-8'); ?></th>
      <th><?php echo htmlspecialchars(t('Violation Date'),ENT_QUOTES,'UTF-8'); ?></th>
      <th><?php echo htmlspecialchars(t('Violation Time'),ENT_QUOTES,'UTF-8'); ?></th>
      <th><?php echo htmlspecialchars(t('License Plate N.'),ENT_QUOTES,'UTF-8'); ?></th>
      <th><?php echo htmlspecialchars(t('Nationality'),ENT_QUOTES,'UTF-8'); ?></th>
      <th><?php echo htmlspecialchars(t('Class'),ENT_QUOTES,'UTF-8'); ?></th>
      <th><?php echo htmlspecialchars(t('Speed'),ENT_QUOTES,'UTF-8'); ?></th>
      <th><?php echo htmlspecialchars(t('Limite vel. veicolo') ,ENT_QUOTES,'UTF-8'); ?></th>
    </tr>
  </thead>
  <tbody>
    <?php $counter = 0; ?>
    <?php foreach($events as $event) { ?>
      <?php if ($event->ext_code != ExtCode::NULL_EXT_CODE)     { ?>
        <?php if ($counter % $perPage == 0) { ?>
          <?php $breakClass = 'break'; ?>
          <?php $counter = 0; ?>
        <?php } else { ?>
          <?php $breakClass = ''; ?>
        <?php } ?>
        <?php $counter++; ?>
        <?php $challengedSpeed = CalculateChallengedSpeed::run($event->Speed, Yii::app()->params['spotSpeedViolation']['percentageTolerance'], Yii::app()->params['spotSpeedViolation']['fixedTolerance'], Yii::app()->params['spotSpeedViolation']['toleranceTable']);; ?>
        <?php $challengedSpeed = number_format($challengedSpeed,2); ?>
        <tr <?php echo MtHaml\Runtime::renderAttributes(array(array('class', $breakClass)), 'html5', 'UTF-8'); ?>>
          <td><?php echo htmlspecialchars($event->ext_code,ENT_QUOTES,'UTF-8'); ?></td>
          <td><?php echo htmlspecialchars(DateHelper::formatISO9075Date($event->StartTime),ENT_QUOTES,'UTF-8'); ?></td>
          <td><?php echo htmlspecialchars(DateHelper::formatISO9075Time($event->StartTime),ENT_QUOTES,'UTF-8'); ?></td>
          <td><?php echo htmlspecialchars($event->Plate,ENT_QUOTES,'UTF-8'); ?></td>
          <td><?php echo htmlspecialchars($event->NationalityCode,ENT_QUOTES,'UTF-8'); ?></td>
          <td>
            <?php echo htmlspecialchars(t($event->Custom_vehicle_type) ." ". CustomPropertyTypeHelper::getLabel($event->Custom_property_type),ENT_QUOTES,'UTF-8'); ?>
          </td>
          <td><?php echo htmlspecialchars($event->Speed,ENT_QUOTES,'UTF-8'); ?></td>
          <td><?php echo htmlspecialchars(implode(';', $event->violationCodes),ENT_QUOTES,'UTF-8'); ?></td>
        </tr>
      <?php } ?>
    <?php } ?>
  </tbody>
</table>
