<?php $plateList = $plateAuthorization->plate_list; ?>
<?php $isBlack = $plateList->mode == PlateList::MODE_BLACK_LIST; ?>
<?php if($isBlack) { ?>
  <?php $imgurl = $plateList->getImageUrl('/images/list_black.png'); ?>
<?php } else { ?>
  <?php $imgurl = $plateList->getImageUrl('/images/list_white.png'); ?>
<?php } ?>
<?php $permesso = $plateAuthorization->permesso; ?>
<div id="plate-autorization-details">
  <div id="plate-autorization-summary">
    <div class="page-header">
      <table width="100%">
        <tr>
          <td>
            <h2>
              <?php if($plateAuthorization->authorizationAccessType == PlateAuthorization::TYPE_WHITELIST) { ?>
                <i class="icon-file-text-alt"></i>
                <?php echo htmlspecialchars(Yii::t("app", "Authorization Details"),ENT_QUOTES,'UTF-8'); ?>
              <?php } else if($plateAuthorization->authorizationAccessType == PlateAuthorization::TYPE_BLACKLIST) { ?>
                <i class="icon-file-text"></i>
                <?php echo htmlspecialchars(Yii::t("app", "Blacklist Details"),ENT_QUOTES,'UTF-8'); ?>
              <?php } ?>
            </h2>
            <h4>
              <?php echo htmlspecialchars($plateList->getListTitleComplete(),ENT_QUOTES,'UTF-8'); ?>
            </h4>
          </td>
          <td>
            <?php if(!empty($imgurl)) { ?>
              <img <?php echo MtHaml\Runtime::renderAttributes(array(array('src', $imgurl), array('width', '100'), array('align', 'right')), 'html5', 'UTF-8'); ?> />
            <?php } ?>
          </td>
        </tr>
      </table>
    </div>
    <div class="left-column span6">
      <div id="plate-autorization-container">
        <?php $this->renderPartial('authorization_details/_plateAuthorization', array('plateAuthorization' => $plateAuthorization))   ; ?>
      </div>
      <div id="plate-autorization-action-container">
        <?php $this->renderPartial('authorization_details/_plateAuthorizationActionsDetails', array('plateAuthorization' => $plateAuthorization))   ; ?>
      </div>
      <div id="plate-authorization-validity-period">
        <?php $this->renderPartial('authorization_details/_validityPeriodDetails', array('validityPeriod' => $plateAuthorization->validityPeriod))   ; ?>
      </div>
    </div>
    <div class="right-column span5">
      <div id="plate-authorization-vehicle">
        <?php $this->renderPartial('authorization_details/_vehicleDetails', array('vehicle' => $plateAuthorization->vehicle))   ; ?>
      </div>
      <div id="plate-autorization-user-container">
        <?php $this->renderPartial('authorization_details/_userDetails', array('user' => $plateAuthorization->user))   ; ?>
      </div>
    </div>
  </div>
  <div class="row">
    <?php if(user()->checkAccess('plate_auth_insert_wizard') && (paramdeep('plateAuthorizations','viewGoToWizardLink') || isset($_REQUEST["fromWizard"]))) { ?>
      <div id="plate-authorization-view-in-wizard" class="span6">
        <?php $viewWizard = Yii::app()->createAbsoluteUrl('plateAuthorization/whiteListWizard',array('plateListId'=>$plateAuthorization->list_code, 'step'=>"4", 'ownerId'=>$plateAuthorization->user->ID, 'vehicleId'=>$plateAuthorization->vehicle->ID, 'validityPeriodId'=>$plateAuthorization->validityPeriod->ID)); ?>
        <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', $viewWizard)), 'html5', 'UTF-8'); ?>>
          <?php echo htmlspecialchars(t('View in wizard'),ENT_QUOTES,'UTF-8'); ?>
        </a>
      </div>
    <?php } ?>
  </div>
  <div class="row">
    <div id="plate-authorization-actions" class="pull-right">
      <div <?php echo MtHaml\Runtime::renderAttributes(array(array('class', ('btn' . ' ' . 'btn-small')), array('data-behavior', 'PrintButton'), array('data-id-div-to-print', ('#plate-autorization-summary'))), 'html5', 'UTF-8'); ?>>
        <i class="icon-print">
          <?php echo htmlspecialchars(t('Print'),ENT_QUOTES,'UTF-8'); ?>
        </i>
      </div>
      <?php $this->printPrintBtn($permesso, true); ?>
      <?php if(Yii::app()->user->checkAccess('plate_auth_export')) { ?>
        <a <?php echo MtHaml\Runtime::renderAttributes(array(array('class', ('btn' . ' ' . 'btn-small')), array('href', (url('plateAuthorization/PlateAuthInfoExport',array('id'=>$plateAuthorization->ID,'type'=>'PLATE_AUTHORIZATION')))), array('title', (t('Export')))), 'html5', 'UTF-8'); ?>>
          <i class="icon-download"></i>
          <?php echo htmlspecialchars(t('Export'),ENT_QUOTES,'UTF-8'); ?>
        </a>
      <?php } ?>
      <?php if(Yii::app()->user->checkAccess('plate_auth_delete')) { ?>
        <a <?php echo MtHaml\Runtime::renderAttributes(array(array('class', ('btn' . ' ' . 'btn-small')), array('href', ($permesso->url_delete)), array('title', (t('Delete'))), array('onclick', ('return confirm(\'' . (t('Are you sure you want to delete this item?')) . '\')'))), 'html5', 'UTF-8'); ?>>
          <i class="icon-trash">
            <?php echo htmlspecialchars(t('Delete'),ENT_QUOTES,'UTF-8'); ?>
          </i>
        </a>
      <?php } ?>
    </div>
  </div>
</div>
