<?php

class RectangleTest extends CTestCase
{

  public function testBuildNewRectangle()
  {
    $rectangle = $this->factoryRectangle();

    $this->assertEquals(new Coordinate(10, 25), $rectangle->topLeft);
    $this->assertEquals(new Coordinate(30, 15), $rectangle->bottomRight);
    $this->assertEquals(new Coordinate(30, 25), $rectangle->topRight);
    $this->assertEquals(new Coordinate(10, 15), $rectangle->bottomLeft);
  }

  public function testHeight()
  {
    $rectangle = $this->factoryRectangle();
    $this->assertEquals(10, $rectangle->height);
  }

  public function testWidth()
  {
    $rectangle = $this->factoryRectangle();
    $this->assertEquals(20, $rectangle->width);
  }

  private function factoryRectangle()
  {
    $topLeft = new Coordinate(10, 25);
    $bottomRight = new Coordinate(30, 15);
    return new Rectangle($topLeft, $bottomRight);
  }

}
