<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of GateDispenser
 *
 * @author a.ronchi
 */
class GateMaster {

    /**
     * La variabile statica privata che conterrà l’istanza univoca
     * della nostra classe.
     */
    private static $instance = null;
    private $gatesMap;


    public static function getInstance() {
        if (self::$instance == null) {
            $c = __CLASS__;
            self::$instance = new $c;
        }

        return self::$instance;
    }

    private function __construct() {
        $this->gatesMap = array();
    }

    public function getGate($gateId) {
        if ($this->isGatePresent($gateId)) {
            return $this->gatesMap[$gateId];
        }
        return null;
    }

    public function addGate($gateObject, $overwrite = true) {
        if ($overwrite || !array_key_exists($gateObject->ID, $this->gatesMap)) {
            $this->gatesMap[$gateObject->ID] = $gateObject;
        }
    }

    public function isGatePresent($gateId) {
        return array_key_exists($gateId, $this->gatesMap);
    }

}
