<?php

/*
 *
 * EVENT SERVER GUI API KEY AIzaSyBagfQcGp_IDNcMGUme4i6J9ffM8ZV_dW8
 *
 * https://developers.google.com/maps/documentation/embed/guide#view_mode
 *
 *
 *
 *
 *
 *
 * https://developers.google.com/maps/documentation/javascript/drawinglayer#drawingmanager_options
 *
 *
 * https://developers.google.com/maps/documentation/javascript/examples/map-simple
 *
 *
 * <iframe width="600" height="450" frameborder="0" style="border: 0"
 * src="https://www.google.com/maps/embed/v1/view?key=AIzaSyBagfQcGp_IDNcMGUme4i6J9ffM8ZV_dW8&center=-33.8569,151.2152&zoom=18&maptype=satellite"
 * allowfullscreen> </iframe>
 *
 *
 */
?>


<div class="page-header">
  <h2>
    <i class="icon-globe"></i>
      <?php echo t('Maps'); ?>      <small> <span
      id="cartography-update-time"></span>
    </small>
  </h2>
</div>
<table style="width: 100%;">
  <tr style="width: 100%;">
    <td style="width: 50%;">
      <div id="map"
        style="width: 100%; height: 500px; border: solid gray 1px;"></div>
    </td>
    <td style="width: 50%;">
      <table class="table table-condensed">
        <thead>
          <tr>
            <th></th>
            <th><?php echo t("Group"); ?></th>
            <th><?php echo t("Latitude"); ?></th>
            <th><?php echo t("Longitude"); ?></th>
          </tr>
        </thead>
        <tbody>
<?php

$coords = array ();

/** @var GateGroup[] $gateGroups */
foreach ( $gateGroups as $group )
{
  if (! isEmpty ( $group->latitude ) && ! isEmpty ( $group->longitude ))
  {
    $groupCoord = new stdClass ();
    $groupCoord->id = intval ( $group->ID );
    $groupCoord->name = $group->name;
    $groupCoord->latitude = doubleval ( $group->latitude );
    $groupCoord->longitude = doubleval ( $group->longitude );
    $groupCoord->coord = new stdClass ();
    $groupCoord->coord->lat = doubleval ( $group->latitude );
    $groupCoord->coord->lng = doubleval ( $group->longitude );
    
    $groupCoord->gates = array ();
    $cntTotal = 0;
    $cntGood = 0;
    foreach ( $group->gates as $gate )
    {
      if ($gate instanceof Gate)
        if (! isEmpty ( $gate->latitude ) && ! isEmpty ( $gate->longitude ))
        {
          $gp = new GatePresenter ( $gate );
          $gateCoord = new stdClass ();
          $gateCoord->id = intval ( $gate->ID );
          $gateCoord->group = intval ( $gate->id_group );
          $gateCoord->description = $gate->Descrizione;
          $gateCoord->name = $gate->short_name;
          $gateCoord->latitude = doubleval ( $gate->latitude );
          $gateCoord->longitude = doubleval ( $gate->longitude );
          $gateCoord->coord = new stdClass ();
          $gateCoord->coord->lat = doubleval ( $gate->latitude );
          $gateCoord->coord->lng = doubleval ( $gate->longitude );
          $gateCoord->status = $gate->Status;
          
          if ($gate->Status == Gate::GS_ALIVE)
            $gateCoord->statusHtml = "<span class=\"icon-circle\" style=\"color: green;\"></span>";
          elseif ($gate->Status == Gate::GS_WARNING)
            $gateCoord->statusHtml = "<span class=\"icon-circle\" style=\"color: orange;\"></span>";
          elseif ($gate->Status == Gate::GS_DEAD)
            $gateCoord->statusHtml = "<span class=\"icon-circle\" style=\"color: red;\"></span>";
          else
            $gateCoord->statusHtml = "<span class=\"icon-circle\" style=\"color: gray;\"></span>";
          
          $cntTotal ++;
          if ($gate->Status == Gate::GS_ALIVE)
            $cntGood ++;
            
            /*
           * // stat violazioni
           * $values[] = $gate->recentlyViolations_New;
           * $values[] = $gate->recentlyViolations_Validated;
           * $values[] = $gate->recentlyViolations_Exported;
           *
           * // stat passaggi
           * $values[] = $gate->recentTransitsDay;
           * $values[] = $gate->recentTransitsWeek;
           * $values[] = $gate->recentTransitsMonth;
           */
          $dayName =   t("D",array(),'gateStatus');
          $weekName =   t("W",array(),'gateStatus');
          $monthName =   t("M",array(),'gateStatus');
          $gateCoord->html = "
        <div id=\"marker_{$gate->ID}\">
        " . t ( 'Gate' ) . ": <b>{$gate->ID}</b> {$gateCoord->statusHtml}<br/>
        <i>{$gp->Descrizione}</i><br/>
        <br/>
        <table class=\"table table-condensed\">
        <thead>
        	<tr><th></th><th>{$dayName}</th><th>>{$weekName}</th><th>>{$monthName}</th></tr>
        </thead>
        <tbody>
        	<tr><th>".t('Transits')."</th><td>{$gp->recentTransitsDay}</td><td>{$gp->recentTransitsWeek}</td><td>{$gp->recentTransitsMonth}</td></tr>
        	<tr><th>".t('Violations')."</th><td>{$gp->recentlyViolations_New}</td><td>{$gp->recentlyViolations_Validated}</td><td>{$gp->recentlyViolations_Exported}</td></tr>
        </tbody>
        </table>
        </div>
        ";
          
          $groupCoord->gates [] = $gateCoord;
        }
    }
    
    $statusHtml = "";
    if (count ( $groupCoord->gates ) > 0)
    {
      if ($cntGood == $cntTotal)
      {
        $groupCoord->status = Gate::GS_ALIVE;
        $groupCoord->statusHtml = "<span class=\"icon-circle\" style=\"color: green;\"></span>";
      }
      elseif ($cntGood == 0)
      {
        $groupCoord->status = Gate::GS_DEAD;
        $groupCoord->statusHtml = "<span class=\"icon-circle\" style=\"color: red;\"></span>";
      }
      else
      {
        $groupCoord->status = Gate::GS_WARNING;
        $groupCoord->statusHtml = "<span class=\"icon-circle\" style=\"color: orange;\"></span>";
      }
      
      $statusHtml = $groupCoord->statusHtml;
      
      $coords [] = $groupCoord;
    }
    else
    {
      $statusHtml = "<span class=\"icon-circle\" style=\"color: red;\"></span>";
    }
    
    echo ("<tr><td>{$statusHtml}</td><td><a href=\"#\" onclick=\"select_group({$group->ID});\">{$group->name}</a></td><td>{$group->latitude}</td><td>{$group->longitude}</td></tr>");
  }
  else
  {
    $statusHtml = "<span class=\"icon-circle\" style=\"color: red;\"></span>";
    echo ("<tr><td>{$statusHtml}</td><td>{$group->name}</td><td>{$group->latitude}</td><td>{$group->longitude}</td></tr>");
  }
}

?></tbody>
      </table>
    </td>
  </tr>
</table>
<script>
      var map;
      var drawingManager;
      var groups;
      
      <?php
      if (count ( $coords ) > 0)
        echo "groups = " . json_encode ( $coords/*,JSON_PRETTY_PRINT*/ ) . ";";
      ?>
      
      function initMap() {// initMap begins here

        var myLatLng = {lat: -34.397, lng: 150.644};
        
        // create map object
        map = new google.maps.Map(document.getElementById('map'), {
          center: myLatLng,
          zoom: 1
        });

        // custom markers
        var iconBase = 'https://maps.google.com/mapfiles/kml/shapes/';        
        for (var groupid in groups)
        {
          var group = groups[groupid];
          for(var gateid in group.gates)
          {
            var gate = group.gates[gateid];

            var infowindow = new google.maps.InfoWindow({
              content: gate.html
            });
            
            var marker = new google.maps.Marker({
              position: gate.coord,
              map: map,
              kgroup: group,
              kgate: gate,
              //label: gate.name,
              title: gate.name,
              popup: infowindow,
              icon: iconBase + 'schools_maps.png'
            });

            infowindow.marker = marker;
            
            marker.addListener('click', function() {
              map.setZoom(15);
              map.setCenter(this.getPosition());
              this.popup.open(map, this);               
            });
          }          
        }
        
      }//initMap ends here
      
      function select_group(id) {// select_group begins here
        var found = -1;
        for (var groupid in groups)
        {
          var group = groups[groupid];
          if( id == group.id )
          {
            found = groupid; 
            break;
          }
        }
        if(found != -1)
        {
          var ok = groups[found];
          map.setCenter(ok.coord);
          map.setZoom(15);
         }
      }// select_group ends here
        
    </script>
<script
  src="https://maps.googleapis.com/maps/api/js?key=AIzaSyBagfQcGp_IDNcMGUme4i6J9ffM8ZV_dW8&callback=initMap&libraries=drawing"
  async defer></script>
