<?php

/** @var CrossingTime $model */
/** @var CrossingTimeController $this */

$this->breadcrumbs=array(
	'Crossing Times'=>array('index'),
	$model->id,
);

$this->menu=array(
	array('label'=>t('Create CrossingTime'),'url'=>array('create'),'visible'=>user()->checkAccess('crossing_time_create')),
	array('label'=>t('Update CrossingTime'),'url'=>array('update','id'=>$model->id),'visible'=>user()->checkAccess('crossing_time_update')),
	array('label'=>t('Delete CrossingTime'),'url'=>array('delete','id'=>$model->id),'confirm'=>'Are you sure you want to delete this item?','visible'=>user()->checkAccess('crossing_time_delete')),
	array('label'=>t('Manage CrossingTime'),'url'=>array('admin'),'visible'=>user()->checkAccess('crossing_time_manage')),
);
?>

<h1>View CrossingTime #<?php echo $model->id; ?></h1>

<?php $this->widget('bootstrap.widgets.TbDetailView',array(
	'data'=>$model,
	'attributes'=>$model->attributeNames(),
)); ?>
