<?php
/** @var EventBehaviorController $this */
/** @var EventBehavior $model */

$this->menu=array(
	array('label'=>t('Create EventBehavior'),'url'=>array('create'),'visible'=>user()->checkAccess('event_behavior_create')),
);

?>
<h1>Manage Event Behaviors</h1>

<?php $this->widget('bootstrap.widgets.TbGridView',array(
	'id'=>'event-behavior-grid',
	'dataProvider'=>$model->search(),
	'filter'=>$model,
	'columns'=>array(
		'ID',
		'id_event',
		'id_behavior',
		'validation_result',
		'comment',
		'epoch',
		/*
		'violation_code',
		*/
    array(
          'class'=>'bootstrap.widgets.TbButtonColumn',
          'buttons'=>array
          (
            'view' => array
            (
                'label'=>t('View'),                
                'visible'=>'user()->checkAccess("event_behavior_view")',
            ),
            'update' => array
            (
                'label'=>t('Update'),                
                'visible'=>'user()->checkAccess("event_behavior_update")',
            ),
            'delete' => array
            (
                'label'=>t('Delete'),                
                'visible'=>'user()->checkAccess("event_behavior_delete")',
                'click'=>"return confirm('".t('Do you confirm?')."');",
            ),
          ),
        ),
	),
)); ?>
