<?php
$this->breadcrumbs = array (
    'Gate Behaviors' => array (
        'index' 
    ),
    'Manage' 
);

?>

<h1><?php echo(t('Manage Gate Behaviors')); ?></h1>

<?php

/** @var GateBehavior $model */

$menu = array ();

if (user ()->checkAccess ( 'gate_behavior_create' ))
  $menu [t ( 'Create GateBehavior' )] = "gateBehavior/create";

if (user ()->checkAccess ( 'gate_behavior_matrix' ))
  $menu [t ( 'Matrix' )] = "gateBehavior/matrix";

$this->printMenuSimple ( "Operations", $menu );
?>

<?php

$this->widget ( 'bootstrap.widgets.TbGridView', array (
    'id' => 'gate-behavior-grid',
    'template' => '{items}{summary}{pager}',
    'ajaxUpdate' => false,
    'dataProvider' => $model->search (),
    'filter' => $model,
    'columns' => array (
        array (
            'name' => 'id_gate',
            'type' => 'raw',
            'value' => 'SystemInfoHelper::getGateCoolName($data->id_gate,true,true,true,true)' 
        ),
        array (
            'name' => 'id_behavior',
            'type' => 'raw',
            'value' => 'SystemInfoHelper::getBehaviorCoolName($data->id_behavior)' 
        ),
        array (
            'name' => 'validate',
            'type' => 'raw',
            'value' => 'SystemInfoHelper::getFullSwitchButtonLabel("gateBehavior", "switchValidate", $data->ID, $data->validate, "Yes","No","green","red",app()->controller->getAbsoluteUrl(),"icon-refresh")' 
        ),
        // array('name'=>'generate_alarm', 'type'=>'raw','value'=>'SystemInfoHelper::getTrafficEventIcon($data->generate_alarm)'),
        array (
            'name' => 'generate_alarm',
            'type' => 'raw',
            'value' => 'SystemInfoHelper::trafficEventSelector($data->ID, $data->generate_alarm, "gateBehavior", "switchGenerateAlarm", "value", app()->controller->getAbsoluteUrl())' 
        ),
        array (
            'name' => 'to_ignore',
            'type' => 'raw',
            'value' => 'SystemInfoHelper::getFullSwitchButtonLabel("gateBehavior", "switchToIgnore", $data->ID, $data->to_ignore, "Yes","No","green","red",app()->controller->getAbsoluteUrl(),"icon-refresh")' 
        ),
        array (
            'name' => 'transfer_from_vt',
            'type' => 'raw',
            'value' => 'SystemInfoHelper::getFullSwitchButtonLabel("gateBehavior", "switchTransVt", $data->ID, $data->transfer_from_vt, "Yes","No","green","red",app()->controller->getAbsoluteUrl(),"icon-refresh")' 
        ),
        array (
            'name' => 'transfer_from_event',
            'type' => 'raw',
            'value' => 'SystemInfoHelper::getFullSwitchButtonLabel("gateBehavior", "switchtransEv", $data->ID, $data->transfer_from_event, "Yes","No","green","red",app()->controller->getAbsoluteUrl(),"icon-refresh")' 
        ),
        array (
            'name' => 'transfer_empty_plates',
            'type' => 'raw',
            'value' => 'SystemInfoHelper::getFullSwitchButtonLabel("gateBehavior", "switchTransEp", $data->ID, $data->transfer_empty_plates, "Yes","No","green","red",app()->controller->getAbsoluteUrl(),"icon-refresh")' 
        ),
        array (
            'name' => 'is_whitelist',
            'type' => 'raw',
            'value' => 'SystemInfoHelper::getFullSwitchButtonLabel("gateBehavior", "switchIsWhitelist", $data->ID, $data->is_whitelist, "Yes","No","green","red",app()->controller->getAbsoluteUrl(),"icon-refresh")' 
        ),
        array (
            'name' => 'epoch' 
        ),
        array (
            'class' => 'bootstrap.widgets.TbButtonColumn' 
        ) 
    ) 
) );
?>
