<?php
$this->breadcrumbs=array(
	'Gate Groups'=>array('index'),
	$model->name,
);

$this->menu=array(
	array('label'=>'List GateGroup','url'=>array('index')),
	array('label'=>'Create GateGroup','url'=>array('create')),
	array('label'=>'Update GateGroup','url'=>array('update','id'=>$model->ID)),
	array('label'=>'Delete GateGroup','url'=>'#','linkOptions'=>array('submit'=>array('delete','id'=>$model->ID),'confirm'=>'Are you sure you want to delete this item?')),
	array('label'=>'Manage GateGroup','url'=>array('admin')),
);
?>

<h1>View GateGroup #<?php echo $model->ID; ?></h1>

<?php $this->widget('bootstrap.widgets.TbDetailView',array(
	'data'=>$model,
	'attributes'=>array(
		'ID',
		'name',
		'epoch',
		'latitude',
		'longitude',
		'altitude',
	),
));

$gates = $model->gates;

?>
<table class="table table-condensed span12">
<thead>
  <tr>
    <th></th>
    <th><?php echo(t("ID")); ?></th>
    <th><?php echo(t("Description")); ?></th>
    <th><?php echo(t("S/N")); ?></th>
    <th><?php echo(t("IP")); ?></th>
    <th><?php echo(t("Device")); ?></th>
    <th><?php echo(t("Short name")); ?></th>    
    <th><?php echo(t("Code")); ?></th>    
</tr>
</thead>
<tbody>
<?php

if( count($gates) <= 0 )
{
echo('<tr><td colspan="8"><center><i>'.t('No results').'</i></center></td></tr>');  
}
else 
{
foreach($gates as $gate)
{
  $gate = new GatePresenter($gate);
?>
  <tr>
    <td><span class="status-icon icon-circle <?php echo ($gate->statusClass); ?>"></span></td>
    <td><?php echo($gate->ID); ?></td>
    <td><?php echo(SystemInfoHelper::getGateCoolName($gate->ID, true, true, true, false)); ?></td>
    <td><?php echo($gate->Gate); ?></td>
    <td><?php echo($gate->IP); ?></td>
    <td><?php echo(t($gate->GateType)); ?></td>
    <td><?php echo($gate->short_name); ?></td>
    <td><?php echo($gate->Code); ?></td>
  </tr>
<?php  
}
}
?>
</tbody>
</table>
