<?php

$yesno = array(
    0=>t('No'),
    1=>t('Yes'),
);

$form=$this->beginWidget('bootstrap.widgets.TbActiveForm',array(
    'id'=>'notification-setting-form',
    'enableAjaxValidation'=>false,
));

?>

<p class="help-block">
	<?php echo(t('Fields with <span class="required">*</span> are required.')); ?>
</p>

<script type="text/javascript">
$(function(){
  $(".dynamicdroplist").change(function(){
    var select = $(this);
    var target = $(select.attr("data-target"));
    var method = select.attr("data-method");
    var index = select.find(":selected").val();
    //target.empty();
  });
});
</script>

<?php 

$form = new TbActiveForm();//remove

echo $form->errorSummary($model);

if(user()->checkAccess('notification_setting_management_advanced'))
{
  echo $form->textFieldRow($model,'description',array('class'=>'span5','maxlength'=>255));

  echo $form->dropDownListRow($model,'enabled',$yesno,array('class'=>'span5','maxlength'=>255));

  echo $form->dropDownListRow($model,'target_type',NotificationSettingController::getTargetTypesArray(),array('class'=>'span5 dynamicdroplist','data-target'=>'#target_id_dropdown','data-method'=>'getTargetTypesIdsArray','maxlength'=>255));

  echo $form->dropDownListRow($model,'target_id',NotificationSettingController::getTargetTypesIdsArray(NotificationSetting::TARGET_TYPE_USER),array('id'=>'target_id_dropdown','class'=>'span5','maxlength'=>10));

  echo $form->dropDownListRow($model,'object_table',NotificationSettingController::getObjectTablesArray(),array('class'=>'span5','maxlength'=>255));

  echo $form->dropDownListRow($model,'endpoint_type',NotificationSettingController::getEndpointTypesArray(),array('class'=>'span5','maxlength'=>255));

  echo $form->textFieldRow($model,'endpoint_address',array('class'=>'span5','maxlength'=>255,/**/'readonly'=>'readonly','title'=>'default'/**/));

  echo $form->dropDownListRow($model,'sound',$yesno,array('class'=>'span5','maxlength'=>255));

  echo $form->dropDownListRow($model,'popup',NotificationSettingController::getPopupArray(),array('class'=>'span5'));

  echo $form->dropDownListRow($model,'level',NotificationSettingController::getLevelsArray(),array('class'=>'span5'));

  if(user()->checkAccess('notification_setting_filter'))
  {
    echo $form->dropDownListRow($model,'filter_type',NotificationSettingController::getFilterTypesArray(),array('class'=>'span5','maxlength'=>255));

    echo $form->textAreaRow($model,'filter',array('rows'=>6, 'cols'=>50, 'class'=>'span8'));
    echo("<br>");
    echo("(er=event_reporting, st=storicotable, gt=gatetable, gg=gate_group, vt=vehicletracetable)");
    echo("<br>");
    echo("<br>");
  }
  else
  {
    echo $form->dropDownListRow($model,'filter_type',NotificationSettingController::getFilterTypesArray(),array('class'=>'span5','maxlength'=>255));

    echo $form->textFieldRow($model,'filter',array('class'=>'span5','maxlength'=>255));
  }

  if(!$model->isNewRecord)
    echo $form->textFieldRow($model,'epoch',array('class'=>'span5','readonly'=>'readonly'));
}
else
{
  echo $form->textFieldRow($model,'description',array('class'=>'span5','maxlength'=>255));

  echo $form->dropDownListRow($model,'enabled',$yesno,array('class'=>'span5','maxlength'=>255));

  echo $form->dropDownListRow($model,'object_table',NotificationSettingController::getObjectTablesArray(),array('class'=>'span5','maxlength'=>255));

  echo $form->dropDownListRow($model,'sound',$yesno,array('class'=>'span5','maxlength'=>255));

  echo $form->dropDownListRow($model,'popup',NotificationSettingController::getPopupArray(),array('class'=>'span5'));

  echo $form->dropDownListRow($model,'filter_type',NotificationSettingController::getFilterTypesArray(),array('class'=>'span5','maxlength'=>255));

  echo $form->textFieldRow($model,'filter',array('class'=>'span5','maxlength'=>255));

  if(!$model->isNewRecord)
    echo $form->textFieldRow($model,'epoch',array('class'=>'span5','readonly'=>'readonly'));
}
?>

<div class="form-actions">
	<?php $this->widget('bootstrap.widgets.TbButton', array(
	    'buttonType'=>'submit',
	    'type'=>'primary',
	    'label'=>$model->isNewRecord ? t('Create') : t('Save'),
		)); ?>
</div>

<?php $this->endWidget(); ?>
