<?php
$this->breadcrumbs=array(
    'Notification Settings'=>array('index'),
    $model->id,
);

$this->menu=array(
    array('label'=>'Create NotificationSetting','url'=>array('create'),'auth'=>'notification_setting_create'),
    array('label'=>'Update NotificationSetting','url'=>array('update','id'=>$model->id),'auth'=>'notification_setting_update'),
    array('label'=>'Delete NotificationSetting','url'=>array('delete','id'=>$model->id),'confirm'=>'Are you sure you want to delete this item?','auth'=>'notification_setting_delete'),
    array('label'=>'Manage NotificationSetting','url'=>array('admin')),
);
?>

<h1>
	<?php echo (t("View NotificationSetting")." $model->id"); ?>
</h1>

<?php $this->widget('bootstrap.widgets.TbDetailView',array(
    'data'=>$model,
    'attributes'=>array(
        'id',
        'description',
        array('name'=>'target_id','type'=>'raw','value'=>SystemInfoHelper::getNotificationSettingTarget($model)),
        array('name'=>'enabled', 'type'=>'raw','value'=>SystemInfoHelper::getFullSwitchButtonLabel("notificationSetting", "switchEnabled", $model->id, $model->enabled, "Yes","No","green","red",app()->controller->getAbsoluteUrl(),"icon-off","notification_setting_update_base")),
        array('name'=>'object_table', 'type'=>'raw','value'=>NotificationSettingController::getObjectTablesArray($model->object_table)),
        array('name'=>'endpoint_type', 'type'=>'raw','value'=>NotificationSettingController::getEndpointTypesArray($model->endpoint_type)),
        array('name'=>'filter_type', 'type'=>'raw','value'=>NotificationSettingController::getFilterTypesArray($model->filter_type)),
        array('name'=>'filter', 'type'=>'raw','value'=>SystemInfoHelper::getNotificationSettingFilter($model)),
        array('name'=>'sound', 'type'=>'raw','value'=>SystemInfoHelper::getFullSwitchButtonLabel("notificationSetting", "switchSound", $model->id, $model->sound, "Yes","No","blue","gray",app()->controller->getAbsoluteUrl(),"icon-volume-up","notification_setting_update_base")),
        array('name'=>'popup', 'type'=>'raw','value'=>SystemInfoHelper::getFullSwitchButtonLabel("notificationSetting", "switchPopup", $model->id, $model->popup, "Yes","No","blue","gray",app()->controller->getAbsoluteUrl(),"icon-comment-alt","notification_setting_update_base")),

        /*
        'description',
        'enabled',
        'target_id',
        'target_type',
        'object_table',
        'endpoint_type',
        'sound',
        'popup',
        */
        
        'level',
        'epoch',
    ),
)); ?>

