<?php
$this->breadcrumbs = array (
    'Plate Auth Insert Profiles' => array (
        'index' 
    ),
    'Manage' 
);

$this->menu = array (
    array (
        'label' => 'Create PlateAuthInsertProfile',
        'url' => array (
            'create' 
        ),
        'auth' => 'plateauthinsertprofile_create' 
    ) 
);

?>

<h1>Manage Plate Auth Insert Profiles</h1>

<?php

$this->widget ( 'bootstrap.widgets.TbGridView', array (
    'id' => 'plate-auth-insert-profile-grid',
    'dataProvider' => $model->search (),
    'filter' => $model,
    'columns' => array (
        'id',
        'name',
        'list_code',
        array (
            'header' => t ( 'List' ),
            'type' => 'html',
            'value' => function (PlateAuthInsertProfile $p)
            {
              if ($p->list_code == - 1)
                return t ( 'Any' );
              else
              {
                $pl = PlateList::findByCode ( $p->list_code );
                if ($pl != null)
                  return $pl->getListTitle ();
                else
                  return t ( "Plate list not founf" );
              }
            } 
        ),
        array (
            'header' => t ( 'Fields' ),
            'type' => 'html',
            'value' => function (PlateAuthInsertProfile $p)
            {
              return count($p->fields);
            } 
        ),
        array (
            'class' => 'bootstrap.widgets.TbButtonColumn',
            'template' => '{view} {clone} {update} {delete}',
            'buttons' => array (
                'view' => array (
                    'visible' => "user()->checkAccess('plateauthinsertprofile_view')" 
                ),
                'clone' => array (
                    'label' => '',
                    'visible' => 'user()->checkAccess("plateauthinsertprofile_clone")',
                    'url' => 'url("plateauthinsertprofile/clone",array("id"=>$data->id))',
                    'options' => array (
                        'class' => 'icon-copy',
                        'title' => t ( 'Clone' ) 
                    ) 
                ),
                'update' => array (
                    'visible' => "user()->checkAccess('plateauthinsertprofile_update')" 
                ),
                'delete' => array (
                    'visible' => "user()->checkAccess('plateauthinsertprofile_delete')" 
                ) 
            ) 
        ) 
    ) 
) );
?>
