<?php
$gates = Gate::getAllGates ();
?>

<h1><?php echo CHtml::link(t("Sections"), url('section')); ?> Matrix</h1>

<table class="table table-condensed">
  <thead>
    <tr>
      <th></th><?php
      foreach ( $gates as $g1 )
        echo ("<th title=\"{$g1->device_model}\">[{$g1->Gate}] {$g1->short_name}</th>");
      ?></tr>
  </thead>
  <tbody>
  </tbody>
<?php

foreach ( $gates as $g1 )
{
  echo ("<tr>");
  echo ("<td title=\"{$g1->device_model}\">[{$g1->Gate}] {$g1->short_name}</td>");
  foreach ( $gates as $g2 )
  {
    $sections = Section::findByGates ( $g1->Gate, $g2->Gate );
    
    $isLoop = ($g1->ID == $g2->ID);
    
    echo ("<td>");
    if (count ( $sections ) > 0)
    {
      foreach ( $sections as $s )
      {
        if (user ()->checkAccess ( 'section_update' ))
          if ($s->enabled)
            echo "<a class=\"icon-off\" style=\"color: green\" href=\"" . url ( 'section/switchenabled', array (
                'id' => $s->id,
                'returnUrl' => url ( 'section/matrix' ) 
            ) ) . "\"></a>";
          else
            echo "<a class=\"icon-off\" style=\"color: red\" href=\"" . url ( 'section/switchenabled', array (
                'id' => $s->id,
                'returnUrl' => url ( 'section/matrix' ) 
            ) ) . "\"></a>";
        else
          echo "<span class=\"icon-off\"></span>";
      }
      if ($isLoop)
        echo "!";
    }
    else if ($isLoop)
      echo "-";
    else if (user ()->checkAccess ( 'section_create' ))
      echo CHtml::link ( "<span title=\"[{$g1->Gate}] {$g1->Descrizione} => [{$g2->Gate}] {$g2->Descrizione}\" class=\"icon-plus\"></span>", url ( "section/createFast", array (
          'from' => $g1->Gate,
          'to' => $g2->Gate 
      ) ) );
    else
      echo "-";
    echo ("</td>");
  }
  echo ("</tr>");
}
?>
</table>

