<?php
/** @var ViolationDocumentController $this */
/** @var ViolationDocument $model */
$this->menu = array (
    array (
        'label' => t ( 'Create ViolationDocument' ),
        'url' => array (
            'create' 
        ),
        'visible' => user ()->checkAccess ( 'violation_document_create' ) 
    ) 
);

?>
<h1>Manage Violation Documents</h1>

<?php

$this->widget ( 'bootstrap.widgets.TbGridView', array (
    'id' => 'violation-document-grid',
    'dataProvider' => $model->search (),
    'filter' => $model,
    'columns' => array (
        'id',
        'id_event_behavior',
        'status',
        // 'document',
        // 'document_size',
        // 'document_filename',
        array (
            'name' => 'document_filename',
            'type' => 'html',
            'value' => '"<a title=\"$data->document_filename\" href=\"".url("violationDocument/download", array("id"=>$data->id))."\">".basename($data->document_filename)."</a>"',
            'visible' => 'user()->checkAccess("violation_document_download")' 
        ),
        // 'last_update',
        // 'epoch',
        array (
            'name' => 'epoch',
            'type' => 'html',
            'value' => 'new DateTimeEx($data->epoch)' 
        ),
        array (
            'header' => t ( 'Behavior' ),
            'type' => 'html',
            'value' => '$data->eventBehaviors->behavior->name' 
        ),
        // 'document_ext',
        // 'document_ext_size',
        // 'document_ext_filename',
        array (
            'class' => 'bootstrap.widgets.TbButtonColumn',
            'buttons' => array (
                'view' => array (
                    'label' => t ( 'View' ),
                    'visible' => 'user()->checkAccess("violation_document_view")' 
                ),
                'update' => array (
                    'label' => t ( 'Update' ),
                    'visible' => 'user()->checkAccess("violation_document_update")' 
                ),
                'delete' => array (
                    'label' => t ( 'Delete' ),
                    'visible' => 'user()->checkAccess("violation_document_delete")',
                    'click' => "return confirm('" . t ( 'Do you confirm?' ) . "');" 
                ) 
            ) 
        ) 
    ) 
) );
?>
