#= require ./behavior
#= require ./mixins/refreshAlertPreviewTable
#= require ./mixins/refreshViolationPreviewTable

class window.GateStatus extends window.Behavior
  @include window.RefreshAlertPreviewTable
  @include window.RefreshViolationPreviewTable

  init: ->
    @$alertsContainer = @domData('alerts-container')
    @$alertsMode = @data('alerts-mode')
    @gateId = @data('gate-id')
    if(@$alertsMode == 'alerts')
      @attachAlertTableLink()
    if(@$alertsMode == 'violations')
      @attachViolationTableLink()
    @operatorTooltip()
  
  attachAlertTableLink: ->
    @$dom.find(".events-alert-link").click =>
      @$alertsContainer.data('gate-id', @gateId)
      @refreshAlertsTable(@gateId)

  attachViolationTableLink: ->
    @$dom.find(".events-alert-link").click =>
      @$alertsContainer.data('gate-id', @gateId)
      @refreshViolationsTable(@gateId)

  operatorTooltip: ->
    $('.kemler-description').tooltip
      placement: 'left'
      trigger: 'click'
      