<?php

class LoginForm extends FormModel
{
  public $username;
  public $password;

  private $_identity;

  public function rules()
  {
    return array(
      array('username, password', 'required'),
      array('password', 'authenticate'),
    );
  }

  public function myAttributeLabels()
  {
    return array(
      'username' => Yii::t('app', 'Username'),
      'password' => Yii::t('app', 'Password'),
    );
  }

  public function authenticate($attribute, $params)
  {
    $this->_identity=new UserIdentity($this->username, $this->password);
    if(!$this->_identity->authenticate())
      $this->addError('password', Yii::t('app', 'Incorrect username or password.'));
  }

  public function login()
  {
    if($this->_identity===null)
    {
      $this->_identity=new UserIdentity($this->username, $this->password);
      $this->_identity->authenticate();
    }
    if($this->_identity->errorCode === UserIdentity::ERROR_NONE)
    {
      $params = Yii::app()->params;
      Yii::app()->user->login($this->_identity);
      return true;
    }
    else
      return false;
  }
}
