<?php
/** @var CrossingTimeController $this */
/** @var CrossingTime $model */
$this->printMenu ( t ( 'Actions' ), array (
    array (
        'label' => t ( 'Create CrossingTime' ),
        'url' => array (
            'create' 
        ),
        'visible' => user ()->checkAccess ( 'crossing_time_create' ) 
    ) 
) );

?>
<h1>Manage Crossing Times</h1>

<?php

$this->widget ( 'bootstrap.widgets.TbGridView', array (
    'id' => 'crossing-time-grid',
    'dataProvider' => $model->search (),
    'filter' => $model,
    'columns' => array (
        'id',
        'timestamp',
        array (
            'name' => 'id_gate_start',
            'type' => 'html',
            'value' => 'SystemInfoHelper::getGateCoolName($data->id_gate_start,true,true,true,true)' 
        ),
        array (
            'name' => 'id_gate_end',
            'type' => 'html',
            'value' => 'SystemInfoHelper::getGateCoolName($data->id_gate_end,true,true,true,true)' 
        ),
        array (
            'name' => 'duration_avg',
            'type' => 'html',
            'value' => 'DateIntervalEnhanced::getFormattedFromString("".($data->duration_avg * 3600)." seconds")' 
        ),
        array (
            'name' => 'done',
            'type' => 'html',
            'value' => 'SystemInfoHelper::getFullSwitchButtonLabel("crossingTime", "switchDone", $data->id, $data->done)' 
        ),
        array (
            'name' => 'result_code',
            'type' => 'html',
            'value' => '"{$data->result_code} (".($data->result_code == CrossingTime::RESPONSE_CODE_SUCCESS ? t("Success") : t("Error")).")"' 
        ),
        'result_message',
        array (
            'class' => 'bootstrap.widgets.TbButtonColumn',
            'buttons' => array (
                'view' => array (
                    'label' => t ( 'View' ),
                    'visible' => 'user()->checkAccess("crossing_time_view")' 
                ),
                'update' => array (
                    'label' => t ( 'Update' ),
                    'visible' => 'user()->checkAccess("crossing_time_update")' 
                ),
                'delete' => array (
                    'label' => t ( 'Delete' ),
                    'visible' => 'user()->checkAccess("crossing_time_delete")',
                    'click' => "return confirm('" . t ( 'Do you confirm?' ) . "');" 
                ) 
            ) 
        ) 
    ) 
) );
?>
