<?php
$this->breadcrumbs=array(
    'Notification Settings'=>array('index'),
    'Manage',
);

$this->printMenuSimple("Operations", array(t('Create NotificationSetting')=>"notificationSetting/create"));

?>

<h1>
	<?php echo(t('Manage Notification Settings')); ?>
</h1>

<?php 

$this->widget('bootstrap.widgets.TbGridView',array(
    'id'=>'notification-setting-grid',
    'dataProvider'=>$model->searchForGrid(),
    'template'=>'{items}{summary}{pager}',
    'filter'=>$model,
    'columns'=>array(
        array('type'=>'raw','value'=>'SystemInfoHelper::getNotificationSettingEndpointType($data)'),
        'description',
        array('name'=>'target_id','type'=>'raw','value'=>'SystemInfoHelper::getNotificationSettingTarget($data)'),
        array('name'=>'enabled', 'type'=>'raw','value'=>'SystemInfoHelper::getFullSwitchButtonLabel("notificationSetting", "switchEnabled", $data->id, $data->enabled, "Yes","No","green","red",app()->controller->getAbsoluteUrl(),"icon-off","notification_setting_update_base")','htmlOptions'=>array('width'=>'50px')),
        array('name'=>'sound', 'type'=>'raw','value'=>'SystemInfoHelper::getFullSwitchButtonLabel("notificationSetting", "switchSound", $data->id, $data->sound, "Yes","No","blue","gray",app()->controller->getAbsoluteUrl(),"icon-volume-up","notification_setting_update_base")','htmlOptions'=>array('width'=>'50px')),
        array('name'=>'popup', 'type'=>'raw','value'=>'SystemInfoHelper::getFullSwitchButtonLabel("notificationSetting", "switchPopup", $data->id, $data->popup, "Yes","No","blue","gray",app()->controller->getAbsoluteUrl(),"icon-comment-alt","notification_setting_update_base")','htmlOptions'=>array('width'=>'50px')),
        array('name'=>'object_table', 'type'=>'raw','value'=>'NotificationSettingController::getObjectTablesArray($data->object_table)'),
        array('name'=>'filter_type', 'type'=>'raw','value'=>'NotificationSettingController::getFilterTypesArray($data->filter_type)'),
        array('name'=>'filter','filter'=>false, 'type'=>'raw','value'=>'SystemInfoHelper::getNotificationSettingFilter($data)'),
        array(
    			'class'=>'bootstrap.widgets.TbButtonColumn',
          'template' => '{view}{update}{delete}{notifications}',
    			'buttons'=>array
          (
              'notifications' => array( //the name {reply} must be same
                  'label' => '', // text label of the button
                  'visible'=>'user()->checkAccess("notification_management")',
                  'url' => 'url("notification/admin",array("setting_id"=>$data->id))', //Your URL According to your wish
                  'options'=>array(
                      'class'=>'icon-bell',
                      'title'=>t('Notifications'),
                  ),
              ),
            'view' => array
            (
                'label'=>t('View'),                
                'visible'=>'user()->checkAccess("notification_setting_view")',
            ),
            'update' => array
            (
                'label'=>t('Update'),                
                'visible'=>'user()->checkAccess("notification_setting_update")',
            ),
            'delete' => array
            (
                'label'=>t('Delete'),                
                'visible'=>'user()->checkAccess("notification_setting_delete")',
            ),
          ),
      	),    
      ),
  )
); ?>
