<?php

class JPGTools extends CComponent
{
  private $imagePath;
  public $width;
  public $height;

  public function __construct($_imagePath)
  {
    $this->imagePath = $_imagePath;

    if(file_exists($_imagePath))
    {
      $image = imagecreatefromjpeg($_imagePath);

      $this->width = imagesx($image);
      $this->height = imagesy($image);

      imagedestroy($image);
    }
    else
    {
      $this->width = 0;
      $this->height = 0;
    }
  }

  public function filename()
  {
    return $this->imagePath;
  }

  public function legalizeX($x)
  {
    return $this->stayInRange($x, 0, $this->width);
  }

  public function legalizeY($y)
  {
    return $this->stayInRange($y, 0, $this->height);
  }

  public function stayInRange($value, $min, $max)
  {
    if($value < $min)
      $value = $min;
    else
    if($value > $max)
      $value = $max;
    return $value;
  }

  public function cropImage($dst_image, $srcX, $srcY, $dstW, $dstH)
  {
    $ok = false;

    $image = imagecreatefromjpeg($this->imagePath);

    $thumb = imagecreatetruecolor( $dstW, $dstH );

    $width = imagesx($image);
    $height = imagesy($image);

    // Resize and crop
    /* imagecopyresampled (
     resource $dst_image ,
        resource $src_image ,

        int $dst_x ,
        int $dst_y ,

        int $src_x ,
        int $src_y ,

        int $dst_w ,
        int $dst_h ,

        int $src_w ,
        int $src_h

    ) */
    $ok = imagecopyresampled(

        $thumb,
        $image,

        0, 0,

        $srcX, $srcY,

        $dstW, $dstH,

        $dstW, $dstH
    );

    imagejpeg($thumb, $dst_image, 80);

    return $ok;
  }

  /**
   * 
   * @param string $imagePath
   * @return string or false on fail
   */
  public static function getKriaXml($imagePath)
  {
    //logLine("getKriaXml($imagePath)");
    if(isLink($imagePath) && filesize_http($imagePath) === false)
    {
      //logLine("getKriaXml :: link not found");
      return FALSE;
    }
    if(!isLink($imagePath) && !fileExists($imagePath))
    {
      //logLine("getKriaXml :: file not found");
      return FALSE;
    }
    $data = file_get_contents($imagePath);
    $dataLength = strlen($data);

    $XmlData = 1;
    $XmlDataFound = FALSE;
    for ($i = 0; $i < ($dataLength - 7); $i++)
    {
      //	if($data[i] == '�')
      {
        if($data[$i+3] == 'K')
        {
          if($data[$i+4] == 'r')
          {
            if($data[$i+5] == 'i')
            {
              if($data[$i+6] == 'a')
              {
                $XmlLength = ord($data[$i + 1]);
                $XmlLength *= 256;
                $XmlLength += ord($data[$i + 2]);
                $XmlLength -= 10;
                $XmlData = substr($data, ($i + 11), $XmlLength-1);
                $XmlDataFound = TRUE;
                break;
              }
            }
          }
        }
      }
    }

    if($XmlDataFound != TRUE)
    {
      //logLine("getKriaXml :: xml data not found");
      return FALSE;
    }

    //logLine("getKriaXml :: xml data found!");
    return $XmlData;
  }

  public function readKriaXml()
  {
    return self::getKriaXml($this->imagePath);
  }

  public function readKriaInfo()
  {
    $kria_xml = $this->readKriaXml();
    if($kria_xml === FALSE)
      return FALSE;
    $xml   = simplexml_load_string($kria_xml);
    return json_decode(json_encode((array) $xml), 1);
  }
}
