<?php

class GateSetsController extends Controller
{
  public $layout='//layouts/column2';

  /**
   * Displays a particular model.
   * @param integer $id the ID of the model to be displayed
   */
  public function actionView($id)
  {
    access_denied_check('gate_set_view');
    $this->render('view',array(
        'model'=>$this->loadModel($id),
    ));
  }

  /**
   * Creates a new model.
   * If creation is successful, the browser will be redirected to the 'view' page.
   */
  public function actionCreate()
  {
    access_denied_check('gate_set_create');
    $model=new GateSet;

    // Uncomment the following line if AJAX validation is needed
    // $this->performAjaxValidation($model);

    if(isset($_POST['GateSet']))
    {
      $model->attributes=$_POST['GateSet'];
      $model->epoch = DateTimeEx::nows();

      $gates = $_REQUEST['Gates'];

      if($model->save())
      {
        foreach($gates as $gid=>$ok)
        {
          $m = new GateSetMatrix();
          $m->epoch = DateTimeEx::nows();
          $m->gate = $gid;
          $m->set = $model->id;
          $m->save();
        }

        $this->redirect(array('view','id'=>$model->id));
      }
    }

    $this->render('create',array(
        'model'=>$model,
    ));
  }

  /**
   * Updates a particular model.
   * If update is successful, the browser will be redirected to the 'view' page.
   * @param integer $id the ID of the model to be updated
   */
  public function actionUpdate($id)
  {
    access_denied_check('gate_set_update');
    $model=$this->loadModel($id);

    // Uncomment the following line if AJAX validation is needed
    // $this->performAjaxValidation($model);

    if(isset($_POST['GateSet']))
    {
      $gates = $_REQUEST['Gates'];

      $model->attributes=$_POST['GateSet'];

      $model->epoch = DateTimeEx::nows();
      if($model->save())
      {
        foreach($model->matrix as $m)
          $m->delete();

        foreach($gates as $gid=>$ok)
        {
          $m = new GateSetMatrix();
          $m->epoch = DateTimeEx::nows();
          $m->gate = $gid;
          $m->set = $model->id;
          $m->save();
        }

        $this->redirect(array('view','id'=>$model->id));
      }
    }

    $this->render('update',array(
        'model'=>$model,
    ));
  }

  /**
   * Deletes a particular model.
   * If deletion is successful, the browser will be redirected to the 'admin' page.
   * @param integer $id the ID of the model to be deleted
   */
  public function actionDelete($id)
  {
    access_denied_check('gate_set_delete');
    if(Yii::app()->request->isPostRequest)
    {
      // we only allow deletion via POST request
      $this->loadModel($id)->delete();

      // if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
      if(!isset($_GET['ajax']))
        $this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
    }
    else
      throw new CHttpException(400,'Invalid request. Please do not repeat this request again.');
  }

  /**
   * Lists all models.
   */
  public function actionIndex()
  {
    $this->redirectTo('gatesets/admin');
  }

  /**
   * Manages all models.
   */
  public function actionAdmin()
  {
    access_denied_check('gate_set_management');
    $model=new GateSet('search');
    $model->unsetAttributes();  // clear any default values
    if(isset($_GET['GateSet']))
      $model->attributes=$_GET['GateSet'];

    $this->render('admin',array(
        'model'=>$model,
    ));
  }

  /**
   * Returns the data model based on the primary key given in the GET variable.
   * If the data model is not found, an HTTP exception will be raised.
   * @param integer the ID of the model to be loaded
   * @return GateSet
   */
  public function loadModel($id)
  {
    $model=GateSet::model()->findByPk($id);
    if($model===null)
      throw new CHttpException(404,'The requested page does not exist.');
    return $model;
  }

  /**
   * Performs the AJAX validation.
   * @param CModel the model to be validated
   */
  protected function performAjaxValidation($model)
  {
    if(isset($_POST['ajax']) && $_POST['ajax']==='gate-set-form')
    {
      echo CActiveForm::validate($model);
      Yii::app()->end();
    }
  }
}
