<?php

class SearchController extends Controller
{
  public function actionIndex()
  {
    $gates = Gate::getAllGates();
    $this->render('index', array('gates' => $gates));
  }

  public function actionFind($startTimestamp, $endTimestamp, $query)
  {
   
    $startDateTime = new DateTime();
    $startDateTime->setTimestamp($startTimestamp);

    $endDateTime = new DateTime();
    $endDateTime->setTimestamp($endTimestamp);

    $searchParams = array(
        'start' => $startDateTime,
        'end' => $endDateTime,
        'query' => $query
    );

    if(!Yii::app()->user->checkAccess('view_all_events'))
      $searchParams[] = 'ext_code_only';

    $dataProvider = Event::model()->search($searchParams);
    
    
    $this->renderPartial('_results', array('dataProvider' => $dataProvider));
  }

}
