<?php

abstract class AbstractMediaAttachmentParser
{
  /**
   * @return Rectangle
   */
  abstract public function getRectangle();
  /**
   * @return boolean
   */
  abstract public function hasRectangle();

  /**
   * @return Rectangle[]
   */
  abstract public function getExtraAreas();

  /**
   * 
   * @var SimpleXMLElement
   */
  protected $xml = null;

  public function __construct($xmlstr)
  {
    if (!is_string($xmlstr))
      throw new CException('Parse accept only string as source xml');
    $this->xml = new SimpleXMLElement($xmlstr);
  }

}
