<?php

/**
 @property integer $ID
 @property string $name
 @property string $description
 @property string $tag
 @property boolean $confirmable
 @property DateTime $epoch
 @property integer $priority
 @property string $alarm_tag_name
 @property GateBehavior[] gateBehaviors
 @property ViolationCode[] violationCodes
 */
class Behavior extends ActiveRecord
{

  const ILLEGAL_SPOT_SPEED = 'Violation';

  const TEST = 'Test';

  const STATISTICS = 'Statistics';

  const BLACKLIST = 'BlackList';

  const INTERESTING_VEHICLE = 'InterestingVehicle';

  const DANGEROUS_GOODS = 'DangerousGoods';

  const GENERIC_EVENT = 'GenericEvent';

  const WRONG_WAY = 'WrongWayAlarm';

  const INTERDISTANCE_TOO_SHORT = 'InterdistanceAlarm';

  const BRAKE_ALARM = 'BrakeAlarm';

  const RED_VIOLATION = 'RedViolation';

  const WHITELIST_VIOLATION = 'WhiteListViolation';

  const VEHICLE_STOPPED = 'StopVehicleViolation';

  const NON_STOP_VEHICLE = 'NonStopVehicleViolation';

  const NON_STRAIGHT_VEHICLE = 'NonStraightVehicle';

  const RIGHT_TURN = 'RightTurnVehicle';

  const LEFT_TURN = 'LeftTurnVehicle';

  const ILLEGAL_MEAN_SPEED = 'MeanSpeedViolation';

  const VEHICLE_TO_CHECK = 'VehicleToCheck';

  const ABNORMAL_BEHAVIOR = 'AbnormalBehavior';

  const CHANGE_OF_LANE = 'ChangeOfLane';

  public static function getTags()
  {
    $class = new ReflectionClass ( Behavior );
    return array_diff ( $class->getConstants (), $class->getParentClass ()
      ->getConstants () );
  }

  /**
   *
   * @param system $className          
   * @return Behavior
   */
  public static function model($className = __CLASS__)
  {
    return parent::model ( $className );
  }

  public function tableName()
  {
    return 'behavior';
  }

  public function rules()
  {
    return array (
        array (
            'confirmable, priority',
            'numerical',
            'integerOnly' => true 
        ),
        array (
            'name, tag',
            'length',
            'max' => 250 
        ),
        array (
            'alarm_tag_name',
            'length',
            'max' => 255 
        ),
        array (
            'description, epoch',
            'safe' 
        ),
        array (
            'tag',
            'unique',
            'allowEmpty' => false 
        ),
        array (
            'ID, name, description, tag, confirmable, epoch, priority, alarm_tag_name',
            'safe',
            'on' => 'search' 
        ) 
    );
  }

  /**
   * Retrieves a list of models based on the current search/filter conditions.
   *
   * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
   */
  public function search()
  {
    // Warning: Please modify the following code to remove attributes that
    // should not be searched.
    $criteria = new CDbCriteria ();
    
    $criteria->compare ( 'ID', $this->ID, true );
    $criteria->compare ( 'name', $this->name, true );
    $criteria->compare ( 'description', $this->description, true );
    $criteria->compare ( 'tag', $this->tag, true );
    $criteria->compare ( 'confirmable', $this->confirmable );
    $criteria->compare ( 'epoch', $this->epoch, true );
    $criteria->compare ( 'priority', $this->priority );
    $criteria->compare ( 'alarm_tag_name', $this->alarm_tag_name, true );
    
    return new CActiveDataProvider ( $this, array (
        'criteria' => $criteria 
    ) );
  }

  public function relations()
  {
    return array (
        'gateBehaviors' => array (
            self::HAS_MANY,
            'GateBehavior',
            'id_behavior' 
        ),
        'violationCodes' => array (
            self::HAS_MANY,
            'ViolationCode',
            'id_behavior' 
        ) 
    );
  }

  public static function getAlarmTagNames()
  {
    $alarmTagName = Behavior::model ()->findAll ( array (
        'select' => 'alarm_tag_name',
        'distinct' => true 
    ) );
    if (is_null ( $alarmTagName ))
      return null;
    
    if (! is_array ( $alarmTagName ))
      $labels = array (
          $alarmTagName 
      );
    
    $arr = array ();
    foreach ( $alarmTagName as $aT )
      $arr [] = $aT->alarm_tag_name;
    
    return $arr;
  }

  public static function getBehaviorList()
  {
    $behaviors = array ();
    foreach ( Behavior::model ()->findAll () as $beh )
      $behaviors [$beh->ID] = t ( $beh->name );
    return $behaviors;
  }

  public function getIsWhitelist()
  {
    return $this->tag == Behavior::WHITELIST_VIOLATION;
  }

  public function getIsRed()
  {
    return $this->tag == Behavior::RED_VIOLATION;
  }

  public function getIsMeanSpeed()
  {
    return $this->tag == Behavior::ILLEGAL_MEAN_SPEED;
  }
}
