<?php $canSeeBlack = user()->checkAccess('blacklist_visibility'); ?>
<?php $canSeeWhite = user()->checkAccess('whitelist_visibility'); ?>
<?php $listShown = array(); ?>
<h2>
  <div class="icon-file-text-alt"></div>
  <?php echo htmlspecialchars(getBWListsLabels(),ENT_QUOTES,'UTF-8'); ?>
</h2>
<table class="table table-striped">
  <thead>
    <th></th>
    <th><?php echo htmlspecialchars(t('Name'),ENT_QUOTES,'UTF-8'); ?></th>
    <th><?php echo htmlspecialchars(t('Source')    ,ENT_QUOTES,'UTF-8'); ?></th>
    <th><?php echo htmlspecialchars(t('Description'),ENT_QUOTES,'UTF-8'); ?></th>
    <th>
      <?php if(Yii::app()->user->checkAccess("plate_list_management") && user()->checkAccess("create_plate_list")) { ?>
        <a <?php echo MtHaml\Runtime::renderAttributes(array(array('class', ('btn' . ' ' . 'btn-mini' . ' ' . 'pull-right')), array('href', (Yii::app()->createAbsoluteUrl('plateList/create')))), 'html5', 'UTF-8'); ?>>
          <?php echo htmlspecialchars(Yii::t('app', 'New List')    ,ENT_QUOTES,'UTF-8'); ?>
        </a>
      <?php } else { ?>
        <?php echo htmlspecialchars(Yii::t('app', 'Actions'),ENT_QUOTES,'UTF-8'); ?>
      <?php } ?>
    </th>
  </thead>
  <tbody>
    <?php foreach($plateLists as $plateList) { ?>
      <?php if(Yii::app()->user->checkAccess("plate_list_management") || $plateList->userHasAccess()) { ?>
        <?php if(($canSeeBlack && $plateList->mode==PlateList::MODE_BLACK_LIST) || ($canSeeWhite && $plateList->mode==PlateList::MODE_WHITE_LIST)) { ?>
          <?php $listShown[] = $plateList; ?>
          <tr <?php echo MtHaml\Runtime::renderAttributes(array(array('class', ((($plateList->editable)? '':'platelist-non-editable')))), 'html5', 'UTF-8'); ?>>
            <td>
              <?php if($plateList->mode==PlateList::MODE_BLACK_LIST) { ?>
                <i class="icon-file-text"></i>
              <?php } else { ?>
                <i class="icon-file-text-alt"></i>
              <?php } ?>
              <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (Yii::app()->createUrl('plateList/view', array('id' => $plateList->id)))), array('target', '_blank'), array('title', (t('Details')))), 'html5', 'UTF-8'); ?>>
                <?php if($plateList->visible) { ?>
                  <i class="icon-eye-open"></i>
                <?php } else { ?>
                  <i class="icon-eye-close"></i>
                <?php } ?>
              </a>
              <?php if(user()->checkAccess("plate_auth_export_list_$code")) { ?>
                <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (Yii::app()->createUrl('plateAuthorization/PlateAuthInfoExportList', array('code' => $plateList->code))))), 'html5', 'UTF-8'); ?>>
                  <div <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'icon-download'), array('title', (t('Export')))), 'html5', 'UTF-8'); ?>></div>
                </a>
              <?php } ?>
            </td>
            <td <?php echo MtHaml\Runtime::renderAttributes(array(array('title', (t('Code').': '.$plateList->code))), 'html5', 'UTF-8'); ?>>
              <?php echo htmlspecialchars($plateList->name,ENT_QUOTES,'UTF-8'); ?>
            </td>
            <td>
              <?php echo htmlspecialchars($plateList->source,ENT_QUOTES,'UTF-8'); ?>
            </td>
            <td>
              <?php echo htmlspecialchars($plateList->title,ENT_QUOTES,'UTF-8'); ?>
            </td>
            <td>
              <div class="pull-right">
                <div class="btn-group">
                  <?php if($plateList->editable) { ?>
                    <?php if($plateList->mode==PlateList::MODE_WHITE_LIST && user()->checkAccess('plate_auth_insert') && (user()->checkAccess('plate_auth_insert_wizard') || user()->checkAccess('plate_auth_insert_fast') || user()->checkAccess('plate_auth_insert_profile'))) { ?>
                      <a class="btn btn-small dropdown-toggle" data-toggle="dropdown" href="#">
                        <?php echo htmlspecialchars(t('New plate authorization'),ENT_QUOTES,'UTF-8'); ?>
                        <span class="caret"></span>
                      </a>
                      <ul class="dropdown-menu pull-right">
                        <?php if($plateList->maxsize > 0 && user()->checkAccess('plate_auth_scheduler')) { ?>
                          <li>
                            <a <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'icon-table'), array('href', (url('plateAuthorization/scheduler',array('plateListId' => $plateList->id))))), 'html5', 'UTF-8'); ?>>
                              <?php echo htmlspecialchars(t("Scheduler"),ENT_QUOTES,'UTF-8'); ?>
                            </a>
                          </li>
                        <?php } ?>
                        <?php if(user()->checkAccess('plate_auth_insert') && user()->checkAccess('plate_auth_insert_fast')) { ?>
                          <li>
                            <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (Yii::app()->createUrl('plateAuthorization/newWhitelist', array('plateListId' => $plateList->id)))), array('target', '_blank')), 'html5', 'UTF-8'); ?>>
                              <?php echo htmlspecialchars(Yii::t("app", ("Fast insert"))             ,ENT_QUOTES,'UTF-8'); ?>
                            </a>
                          </li>
                        <?php } ?>
                        <?php if(user()->checkAccess('plate_auth_insert') && user()->checkAccess('plate_auth_insert_wizard')) { ?>
                          <li>
                            <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (Yii::app()->createUrl('plateAuthorization/whiteListWizard', array('plateListId' => $plateList->code)))), array('target', '_blank')), 'html5', 'UTF-8'); ?>>
                              <?php echo htmlspecialchars(Yii::t("app", ("Wizard"))              ,ENT_QUOTES,'UTF-8'); ?>
                            </a>
                          </li>
                        <?php } ?>
                        <?php if(user()->checkAccess('plate_auth_insert') && user()->checkAccess('plate_auth_insert_profile')) { ?>
                          <?php foreach(PlateAuthInsertProfile::model()->findAll() as $paip) { ?>
                            <?php if(user()->checkAccess("plate_auth_insert_profile_".$paip->id) && ($paip->list_code==-1 || $paip->list_code==$plateList->code)) { ?>
                              <li>
                                <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (Yii::app()->createUrl('plateAuthorization/NewPlateAuthProfile', array('plateListId' => $plateList->code, 'profileId'=>$paip->id)))), array('target', '_blank')), 'html5', 'UTF-8'); ?>>
                                  <?php echo htmlspecialchars(Yii::t("app", $paip->description),ENT_QUOTES,'UTF-8'); ?>
                                </a>
                              </li>
                            <?php } ?>
                          <?php } ?>
                        <?php } ?>
                      </ul>
                    <?php } ?>
                    <?php if($plateList->mode==PlateList::MODE_BLACK_LIST) { ?>
                      <?php if(user()->checkAccess('plate_auth_insert')); ?>
                      <div class="btn-group">
                        <?php if(user()->checkAccess('plate_auth_insert_fast')) { ?>
                          <a <?php echo MtHaml\Runtime::renderAttributes(array(array('class', ('btn' . ' ' . 'btn-small')), array('href', (Yii::app()->createUrl('plateAuthorization/newBlacklist', array('plateListId' => $plateList->id))))), 'html5', 'UTF-8'); ?>>
                            <?php echo htmlspecialchars(Yii::t("app", ("Add vehicle")),ENT_QUOTES,'UTF-8'); ?>
                          </a>
                        <?php } ?>
                        <?php if(user()->checkAccess('plate_auth_insert_profile')) { ?>
                          <?php foreach(PlateAuthInsertProfile::model()->findAll() as $paip) { ?>
                            <?php if(user()->checkAccess("plate_auth_insert_profile_".$paip->id) && ($paip->list_code==-1 || $paip->list_code==$plateList->code)) { ?>
                              <a <?php echo MtHaml\Runtime::renderAttributes(array(array('class', ('btn' . ' ' . 'btn-small')), array('href', (Yii::app()->createUrl('plateAuthorization/NewPlateAuthProfile', array('plateListId' => $plateList->code, 'profileId'=>$paip->id)))), array('target', '_blank')), 'html5', 'UTF-8'); ?>>
                                <?php echo htmlspecialchars(Yii::t("app", $paip->description),ENT_QUOTES,'UTF-8'); ?>
                              </a>
                            <?php } ?>
                          <?php } ?>
                        <?php } ?>
                      </div>
                    <?php } ?>
                  <?php } ?>
                </div>
                <?php if(user()->checkAccess('plate_auth_status')) { ?>
                  <div class="btn-group">
                    <a <?php echo MtHaml\Runtime::renderAttributes(array(array('class', ('btn' . ' ' . 'btn-small')), array('href', (url('plateAuthorization/whitelistStatus', array('plateListId'=>$plateList->code))))), 'html5', 'UTF-8'); ?>>
                      <?php if($plateList->isWhitelist())  { ?>
                        <?php echo htmlspecialchars(Yii::t("app", ("Manage plate authorizations")),ENT_QUOTES,'UTF-8'); ?>
                      <?php } else { ?>
                        <?php echo htmlspecialchars(Yii::t("app", ("Manage blacklists")),ENT_QUOTES,'UTF-8'); ?>
                      <?php } ?>
                    </a>
                  </div>
                <?php } ?>
                <div class="btn-group">
                  <a <?php echo MtHaml\Runtime::renderAttributes(array(array('class', ('btn' . ' ' . 'btn-small')), array('href', (url('plateAuthorization/list', array('plateListId'=>$plateList->id))))), 'html5', 'UTF-8'); ?>>
                    <?php echo htmlspecialchars(Yii::t("app", ("Manage list")),ENT_QUOTES,'UTF-8'); ?>
                  </a>
                </div>
              </div>
            </td>
          </tr>
        <?php } ?>
      <?php } ?>
    <?php } ?>
  </tbody>
</table>
<?php if(user()->checkAccess('plate_auth_status') && user()->checkAccess('plate_auth_status_global')) { ?>
  <h4>
    <a <?php echo MtHaml\Runtime::renderAttributes(array(array('class', ('btn' . ' ' . 'btn-mini' . ' ' . 'pull-right')), array('href', (url('plateAuthorization/whitelistStatus', array('plateListId'=>-1)))), array('style', 'margin-left: 10px;')), 'html5', 'UTF-8'); ?>>
      <?php echo htmlspecialchars(t('Manage plate authorizations for all lists'),ENT_QUOTES,'UTF-8'); ?>
    </a>
  </h4>
<?php } ?>
<?php if(user()->checkAccess('plate_auth_import')) { ?>
  <h4>
    <a <?php echo MtHaml\Runtime::renderAttributes(array(array('class', ('btn' . ' ' . 'btn-mini' . ' ' . 'pull-right')), array('href', (url('plateAuthorization/PlateAuthInfoImport'))), array('style', 'margin-left: 10px;')), 'html5', 'UTF-8'); ?>>
      <?php echo htmlspecialchars(t('Import plate authorizations'),ENT_QUOTES,'UTF-8'); ?>
    </a>
  </h4>
<?php } ?>
<?php if(user()->checkAccess('plate_auth_export_all')) { ?>
  <h4>
    <a <?php echo MtHaml\Runtime::renderAttributes(array(array('class', ('btn' . ' ' . 'btn-mini' . ' ' . 'pull-right')), array('href', (url('plateAuthorization/PlateAuthInfoExportAll'))), array('style', 'margin-left: 10px;'), array('onclick', ('return confirm(\'' . (t('Confirm operation?')) . '\');'))), 'html5', 'UTF-8'); ?>>
      <?php echo htmlspecialchars(t('Export all plate authorizations'),ENT_QUOTES,'UTF-8'); ?>
    </a>
  </h4>
<?php } ?>
<?php if(user()->checkAccess('plate_simulate_transit')) { ?>
  <h4>
    <a <?php echo MtHaml\Runtime::renderAttributes(array(array('class', ('btn' . ' ' . 'btn-mini' . ' ' . 'pull-right')), array('href', (url('plateAuthorization/TransitSimulation'))), array('style', 'margin-left: 10px;')), 'html5', 'UTF-8'); ?>>
      <?php echo htmlspecialchars(t('Simulate transit'),ENT_QUOTES,'UTF-8'); ?>
    </a>
  </h4>
<?php } ?>
<?php if( count($listShown)<=0 && !(user()->checkAccess("plate_list_management") || user()->checkAccess("plate_list_view")) ) { ?>
  <?php $this->redirect(Yii::app()->createUrl()); ?>
<?php } ?>
<?php if( count($listShown) == 1 && !user()->checkAccess("plate_list_management") ) { ?>
  <?php $this->redirect(Yii::app()->createUrl('plateAuthorization/list', array('plateListId' => $listShown[0]->id))); ?>
<?php } ?>
