<?php

use FactoryGirl\Factory as FactoryGirl;

class UserLoginSessionTest extends DbTestCase
{

  public function testExpireOpenSession()
  {
    $user = FactoryGirl::create('User');
    for ($i=0; $i<2; $i++)
      $this->factoryOpenSession($user);

    $expiration = new DateTime();

    UserLoginSession::model()->expireOpenSessions($user, $expiration);

    foreach($user->loginSessions as $session)
      $this->assertEquals($expiration->format('Y-m-d H:i:s'), $session->logout_at);
  }

  private function factoryOpenSession($user)
  {
    return FactoryGirl::create('UserLoginSession', array('id_user' => $user->id), 'open');
  }

}
